/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.jdbc.dialect;

import org.seasar.doma.internal.jdbc.dialect.StandardPagingTransformer;
import org.seasar.doma.internal.jdbc.sql.node.ForUpdateClauseNode;
import org.seasar.doma.internal.jdbc.sql.node.FragmentNode;
import org.seasar.doma.internal.jdbc.sql.node.FromClauseNode;
import org.seasar.doma.internal.jdbc.sql.node.SelectClauseNode;
import org.seasar.doma.internal.jdbc.sql.node.SelectStatementNode;
import org.seasar.doma.internal.jdbc.sql.node.WhereClauseNode;
import org.seasar.doma.jdbc.SqlNode;

public class OraclePagingTransformer
extends StandardPagingTransformer {
    public OraclePagingTransformer(long offset, long limit) {
        super(offset, limit);
    }

    @Override
    public SqlNode visitSelectStatementNode(SelectStatementNode node, Void p) {
        ForUpdateClauseNode forUpdate;
        if (this.processed) {
            return node;
        }
        this.processed = true;
        SelectStatementNode subStatement = new SelectStatementNode();
        subStatement.setSelectClauseNode(node.getSelectClauseNode());
        subStatement.setFromClauseNode(node.getFromClauseNode());
        subStatement.setWhereClauseNode(node.getWhereClauseNode());
        subStatement.setGroupByClauseNode(node.getGroupByClauseNode());
        subStatement.setHavingClauseNode(node.getHavingClauseNode());
        subStatement.setOrderByClauseNode(node.getOrderByClauseNode());
        SelectClauseNode select = new SelectClauseNode("select");
        select.addNode(new FragmentNode(" * "));
        FromClauseNode from = new FromClauseNode("from");
        from.addNode(new FragmentNode(" ( select temp_.*, rownum doma_rownumber_ from ( "));
        from.addNode(subStatement);
        from.addNode(new FragmentNode(" ) temp_ ) "));
        WhereClauseNode where = new WhereClauseNode("where");
        where.addNode(new FragmentNode(" "));
        if (this.offset >= 0L) {
            where.addNode(new FragmentNode("doma_rownumber_ > "));
            where.addNode(new FragmentNode(String.valueOf(this.offset)));
        }
        if (this.limit > 0L) {
            if (this.offset >= 0L) {
                where.addNode(new FragmentNode(" and "));
            }
            where.addNode(new FragmentNode("doma_rownumber_ <= "));
            long bias = this.offset < 0L ? 0L : this.offset;
            where.addNode(new FragmentNode(String.valueOf(bias + this.limit)));
        }
        if ((forUpdate = node.getForUpdateClauseNode()) != null) {
            where.addNode(new FragmentNode(" "));
        }
        SelectStatementNode result = new SelectStatementNode();
        result.setSelectClauseNode(select);
        result.setFromClauseNode(from);
        result.setWhereClauseNode(where);
        result.setForUpdateClauseNode(forUpdate);
        return result;
    }
}

