/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.jdbc.command;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.seasar.doma.internal.jdbc.command.EntityFetcher;
import org.seasar.doma.internal.jdbc.command.ResultSetHandler;
import org.seasar.doma.internal.jdbc.query.SelectQuery;
import org.seasar.doma.internal.jdbc.sql.PreparedSql;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.jdbc.IterationCallback;
import org.seasar.doma.jdbc.IterationContext;
import org.seasar.doma.jdbc.NoResultException;
import org.seasar.doma.jdbc.PostIterationCallback;
import org.seasar.doma.jdbc.entity.EntityType;

public class EntityIterationHandler<R, E>
implements ResultSetHandler<R> {
    protected final EntityType<E> entityType;
    protected final IterationCallback<R, E> iterationCallback;

    public EntityIterationHandler(EntityType<E> entityType, IterationCallback<R, E> iterationCallback) {
        AssertionUtil.assertNotNull(entityType, iterationCallback);
        this.entityType = entityType;
        this.iterationCallback = iterationCallback;
    }

    @Override
    public R handle(ResultSet resultSet, SelectQuery query) throws SQLException {
        EntityFetcher<E> fetcher = new EntityFetcher<E>(query, this.entityType);
        IterationContext iterationContext = new IterationContext();
        boolean existent = false;
        R result = null;
        while (resultSet.next()) {
            existent = true;
            E entity = this.entityType.newEntity();
            fetcher.fetch(resultSet, entity);
            result = this.iterationCallback.iterate(entity, iterationContext);
            if (!iterationContext.isExited()) continue;
            return result;
        }
        if (query.isResultEnsured() && !existent) {
            PreparedSql sql = query.getSql();
            throw new NoResultException(sql);
        }
        if (this.iterationCallback instanceof PostIterationCallback) {
            result = ((PostIterationCallback)this.iterationCallback).postIterate(result, iterationContext);
        }
        return result;
    }
}

