/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.jdbc.command;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.seasar.doma.internal.jdbc.command.BasicFetcher;
import org.seasar.doma.internal.jdbc.command.ResultSetHandler;
import org.seasar.doma.internal.jdbc.query.SelectQuery;
import org.seasar.doma.internal.jdbc.sql.PreparedSql;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.jdbc.IterationCallback;
import org.seasar.doma.jdbc.IterationContext;
import org.seasar.doma.jdbc.NoResultException;
import org.seasar.doma.jdbc.PostIterationCallback;
import org.seasar.doma.jdbc.domain.DomainType;
import org.seasar.doma.jdbc.domain.DomainWrapper;
import org.seasar.doma.wrapper.Wrapper;

public class DomainIterationHandler<R, D>
implements ResultSetHandler<R> {
    protected final DomainType<?, D> domainType;
    protected final IterationCallback<R, D> iterationCallback;

    public DomainIterationHandler(DomainType<?, D> domainType, IterationCallback<R, D> iterationCallback) {
        AssertionUtil.assertNotNull(domainType, iterationCallback);
        this.domainType = domainType;
        this.iterationCallback = iterationCallback;
    }

    @Override
    public R handle(ResultSet resultSet, SelectQuery query) throws SQLException {
        BasicFetcher fetcher = new BasicFetcher(query);
        IterationContext iterationContext = new IterationContext();
        boolean existent = false;
        R result = null;
        while (resultSet.next()) {
            existent = true;
            DomainWrapper<?, Object> wrapper = this.domainType.getWrapper(null);
            fetcher.fetch(resultSet, (Wrapper<?>)wrapper);
            result = this.iterationCallback.iterate(wrapper.getDomain(), iterationContext);
            if (!iterationContext.isExited()) continue;
            return result;
        }
        if (query.isResultEnsured() && !existent) {
            PreparedSql sql = query.getSql();
            throw new NoResultException(sql);
        }
        if (this.iterationCallback instanceof PostIterationCallback) {
            result = ((PostIterationCallback)this.iterationCallback).postIterate(result, iterationContext);
        }
        return result;
    }
}

