/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.jdbc.command;

import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.seasar.doma.internal.jdbc.command.ParameterBinder;
import org.seasar.doma.internal.jdbc.command.RegisterOutParameterFunction;
import org.seasar.doma.internal.jdbc.command.SetValueFunction;
import org.seasar.doma.internal.jdbc.query.Query;
import org.seasar.doma.internal.jdbc.sql.BasicInOutParameter;
import org.seasar.doma.internal.jdbc.sql.BasicInParameter;
import org.seasar.doma.internal.jdbc.sql.BasicListParameter;
import org.seasar.doma.internal.jdbc.sql.BasicListResultParameter;
import org.seasar.doma.internal.jdbc.sql.BasicOutParameter;
import org.seasar.doma.internal.jdbc.sql.BasicResultParameter;
import org.seasar.doma.internal.jdbc.sql.CallableSqlParameter;
import org.seasar.doma.internal.jdbc.sql.CallableSqlParameterVisitor;
import org.seasar.doma.internal.jdbc.sql.DomainInOutParameter;
import org.seasar.doma.internal.jdbc.sql.DomainInParameter;
import org.seasar.doma.internal.jdbc.sql.DomainListParameter;
import org.seasar.doma.internal.jdbc.sql.DomainListResultParameter;
import org.seasar.doma.internal.jdbc.sql.DomainOutParameter;
import org.seasar.doma.internal.jdbc.sql.DomainResultParameter;
import org.seasar.doma.internal.jdbc.sql.EntityListParameter;
import org.seasar.doma.internal.jdbc.sql.EntityListResultParameter;
import org.seasar.doma.internal.jdbc.sql.InParameter;
import org.seasar.doma.internal.jdbc.sql.ListParameter;
import org.seasar.doma.internal.jdbc.sql.MapListParameter;
import org.seasar.doma.internal.jdbc.sql.MapListResultParameter;
import org.seasar.doma.internal.jdbc.sql.OutParameter;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.jdbc.JdbcMappingVisitor;
import org.seasar.doma.jdbc.dialect.Dialect;
import org.seasar.doma.jdbc.type.JdbcType;
import org.seasar.doma.wrapper.Wrapper;

public class CallableSqlParameterBinder
implements ParameterBinder<CallableStatement, CallableSqlParameter> {
    protected final Query query;

    public CallableSqlParameterBinder(Query query) {
        AssertionUtil.assertNotNull(query);
        this.query = query;
    }

    @Override
    public void bind(CallableStatement callableStatement, List<? extends CallableSqlParameter> parameters) throws SQLException {
        AssertionUtil.assertNotNull((Object)callableStatement, parameters);
        BindingVisitor visitor = new BindingVisitor(this.query, callableStatement);
        for (CallableSqlParameter callableSqlParameter : parameters) {
            callableSqlParameter.accept(visitor, null);
        }
    }

    protected static class BindingVisitor
    implements CallableSqlParameterVisitor<Void, Void, SQLException> {
        protected final Dialect dialect;
        protected final JdbcMappingVisitor jdbcMappingVisitor;
        protected final CallableStatement callableStatement;
        protected int index = 1;

        public BindingVisitor(Query query, CallableStatement callableStatement) {
            this.dialect = query.getConfig().getDialect();
            this.jdbcMappingVisitor = this.dialect.getJdbcMappingVisitor();
            this.callableStatement = callableStatement;
        }

        @Override
        public <V> Void visitBasicListParameter(BasicListParameter<V> parameter, Void p) throws SQLException {
            this.handleListParameter(parameter);
            return null;
        }

        @Override
        public <V, D> Void visitDomainListParameter(DomainListParameter<V, D> parameter, Void p) throws SQLException {
            this.handleListParameter(parameter);
            return null;
        }

        @Override
        public <E> Void visitEntityListParameter(EntityListParameter<E> parameter, Void p) throws SQLException {
            this.handleListParameter(parameter);
            return null;
        }

        @Override
        public Void visitMapListParameter(MapListParameter parameter, Void p) throws SQLException {
            this.handleListParameter(parameter);
            return null;
        }

        @Override
        public <V> Void visitBasicListResultParameter(BasicListResultParameter<V> parameter, Void p) throws SQLException {
            this.handleListParameter(parameter);
            return null;
        }

        @Override
        public <V, D> Void visitDomainListResultParameter(DomainListResultParameter<V, D> parameter, Void p) throws SQLException {
            this.handleListParameter(parameter);
            return null;
        }

        @Override
        public <E> Void visitEntityListResultParameter(EntityListResultParameter<E> parameter, Void p) throws SQLException {
            this.handleListParameter(parameter);
            return null;
        }

        @Override
        public Void visitMapListResultParameter(MapListResultParameter parameter, Void p) throws SQLException {
            this.handleListParameter(parameter);
            return null;
        }

        protected void handleListParameter(ListParameter<?, ?> parameter) throws SQLException {
            if (this.dialect.supportsResultSetReturningAsOutParameter()) {
                JdbcType<ResultSet> resultSetType = this.dialect.getResultSetType();
                resultSetType.registerOutParameter(this.callableStatement, this.index);
                ++this.index;
            }
        }

        @Override
        public <V> Void visitBasicInOutParameter(BasicInOutParameter<V> parameter, Void p) throws SQLException {
            this.handleInParameter(parameter);
            this.handleOutParameter(parameter);
            ++this.index;
            return null;
        }

        @Override
        public <V, D> Void visitDomainInOutParameter(DomainInOutParameter<V, D> parameter, Void p) throws SQLException {
            this.handleInParameter(parameter);
            this.handleOutParameter(parameter);
            ++this.index;
            return null;
        }

        @Override
        public Void visitBasicInParameter(BasicInParameter parameter, Void p) throws SQLException {
            this.handleInParameter(parameter);
            ++this.index;
            return null;
        }

        @Override
        public <V, D> Void visitDomainInParameter(DomainInParameter<V, D> parameter, Void p) throws SQLException {
            this.handleInParameter(parameter);
            ++this.index;
            return null;
        }

        protected void handleInParameter(InParameter parameter) throws SQLException {
            parameter.getWrapper().accept(this.jdbcMappingVisitor, new SetValueFunction(this.callableStatement, this.index));
        }

        @Override
        public <V> Void visitBasicOutParameter(BasicOutParameter<V> parameter, Void p) throws SQLException {
            this.handleOutParameter(parameter);
            ++this.index;
            return null;
        }

        @Override
        public <V, D> Void visitDomainOutParameter(DomainOutParameter<V, D> parameter, Void p) throws SQLException {
            this.handleOutParameter(parameter);
            ++this.index;
            return null;
        }

        protected void handleOutParameter(OutParameter<?> parameter) throws SQLException {
            parameter.getWrapper().accept(this.jdbcMappingVisitor, new RegisterOutParameterFunction(this.callableStatement, this.index));
        }

        @Override
        public <V> Void visitBasicResultParameter(BasicResultParameter<V> parameter, Void p) throws SQLException {
            Wrapper<V> wrapper = parameter.getWrapper();
            wrapper.accept(this.jdbcMappingVisitor, new RegisterOutParameterFunction(this.callableStatement, this.index));
            ++this.index;
            return null;
        }

        @Override
        public <V, D> Void visitDomainResultParameter(DomainResultParameter<V, D> parameter, Void p) throws SQLException {
            Wrapper<V> wrapper = parameter.getWrapper();
            wrapper.accept(this.jdbcMappingVisitor, new RegisterOutParameterFunction(this.callableStatement, this.index));
            ++this.index;
            return null;
        }
    }
}

