/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.jdbc.command;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import org.seasar.doma.internal.jdbc.command.BatchModifyCommand;
import org.seasar.doma.internal.jdbc.query.BatchInsertQuery;
import org.seasar.doma.internal.jdbc.sql.PreparedSql;
import org.seasar.doma.jdbc.BatchUniqueConstraintException;
import org.seasar.doma.jdbc.dialect.Dialect;

public class BatchInsertCommand
extends BatchModifyCommand<BatchInsertQuery> {
    public BatchInsertCommand(BatchInsertQuery query) {
        super(query);
    }

    @Override
    protected int[] executeInternal(PreparedStatement preparedStatement, List<PreparedSql> sqls) throws SQLException {
        if (((BatchInsertQuery)this.query).isBatchSupported()) {
            return this.executeBatch(preparedStatement, sqls);
        }
        int sqlSize = sqls.size();
        int[] updatedRows = new int[sqlSize];
        for (int i = 0; i < sqlSize; ++i) {
            PreparedSql sql = sqls.get(i);
            this.log(sql);
            this.bindParameters(preparedStatement, sql);
            updatedRows[i] = this.executeUpdate(preparedStatement, sql);
            ((BatchInsertQuery)this.query).generateId(preparedStatement, i);
        }
        return updatedRows;
    }

    protected int executeUpdate(PreparedStatement preparedStatement, PreparedSql sql) throws SQLException {
        try {
            return preparedStatement.executeUpdate();
        }
        catch (SQLException e) {
            Dialect dialect = ((BatchInsertQuery)this.query).getConfig().getDialect();
            if (dialect.isUniqueConstraintViolated(e)) {
                throw new BatchUniqueConstraintException(sql, (Throwable)e);
            }
            throw e;
        }
    }
}

