/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.jdbc.command;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.seasar.doma.internal.jdbc.command.BasicFetcher;
import org.seasar.doma.internal.jdbc.command.ResultSetHandler;
import org.seasar.doma.internal.jdbc.query.SelectQuery;
import org.seasar.doma.internal.jdbc.sql.PreparedSql;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.jdbc.NoResultException;
import org.seasar.doma.wrapper.Wrapper;

public class BasicResultListHandler<V>
implements ResultSetHandler<List<V>> {
    protected final Wrapper<V> wrapper;

    public BasicResultListHandler(Wrapper<V> wrapper) {
        AssertionUtil.assertNotNull(wrapper);
        this.wrapper = wrapper;
    }

    @Override
    public List<V> handle(ResultSet resultSet, SelectQuery query) throws SQLException {
        ArrayList<V> results = new ArrayList<V>();
        BasicFetcher fetcher = new BasicFetcher(query);
        while (resultSet.next()) {
            fetcher.fetch(resultSet, this.wrapper);
            results.add(this.wrapper.get());
        }
        if (query.isResultEnsured() && results.isEmpty()) {
            PreparedSql sql = query.getSql();
            throw new NoResultException(sql);
        }
        return results;
    }
}

