/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.jdbc.command;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.seasar.doma.internal.jdbc.command.BasicFetcher;
import org.seasar.doma.internal.jdbc.command.ResultSetHandler;
import org.seasar.doma.internal.jdbc.query.SelectQuery;
import org.seasar.doma.internal.jdbc.sql.PreparedSql;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.jdbc.IterationCallback;
import org.seasar.doma.jdbc.IterationContext;
import org.seasar.doma.jdbc.NoResultException;
import org.seasar.doma.jdbc.PostIterationCallback;
import org.seasar.doma.wrapper.Wrapper;

public class BasicIterationHandler<R, V>
implements ResultSetHandler<R> {
    protected final Wrapper<V> wrapper;
    protected final IterationCallback<R, V> iterationCallback;

    public BasicIterationHandler(Wrapper<V> wrapper, IterationCallback<R, V> iterationCallback) {
        AssertionUtil.assertNotNull(wrapper);
        this.wrapper = wrapper;
        this.iterationCallback = iterationCallback;
    }

    @Override
    public R handle(ResultSet resultSet, SelectQuery query) throws SQLException {
        BasicFetcher fetcher = new BasicFetcher(query);
        IterationContext iterationContext = new IterationContext();
        boolean existent = false;
        R result = null;
        while (resultSet.next()) {
            existent = true;
            fetcher.fetch(resultSet, this.wrapper);
            result = this.iterationCallback.iterate(this.wrapper.get(), iterationContext);
            if (!iterationContext.isExited()) continue;
            return result;
        }
        if (query.isResultEnsured() && !existent) {
            PreparedSql sql = query.getSql();
            throw new NoResultException(sql);
        }
        if (this.iterationCallback instanceof PostIterationCallback) {
            result = ((PostIterationCallback)this.iterationCallback).postIterate(result, iterationContext);
        }
        return result;
    }
}

