/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.jdbc.command;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.seasar.doma.internal.jdbc.command.GetValueFunction;
import org.seasar.doma.internal.jdbc.command.ResultFetcher;
import org.seasar.doma.internal.jdbc.query.Query;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.jdbc.JdbcMappingVisitor;
import org.seasar.doma.jdbc.NonSingleColumnException;
import org.seasar.doma.jdbc.Sql;
import org.seasar.doma.wrapper.Wrapper;

public class BasicFetcher
implements ResultFetcher<ResultSet, Wrapper<?>> {
    protected final Query query;
    protected boolean columnCountValidated;

    public BasicFetcher(Query query) {
        AssertionUtil.assertNotNull(query);
        this.query = query;
    }

    @Override
    public void fetch(ResultSet resultSet, Wrapper<?> wrapper) throws SQLException {
        AssertionUtil.assertNotNull((Object)resultSet, wrapper);
        if (!this.columnCountValidated) {
            this.validateColumnCount(resultSet);
        }
        JdbcMappingVisitor jdbcMappingVisitor = this.query.getConfig().getDialect().getJdbcMappingVisitor();
        GetValueFunction function = new GetValueFunction(resultSet, 1);
        wrapper.accept(jdbcMappingVisitor, function);
    }

    protected void validateColumnCount(ResultSet resultSet) throws SQLException {
        int columnCount = this.getColumnCount(resultSet);
        if (columnCount != 1) {
            Sql<?> sql = this.query.getSql();
            throw new NonSingleColumnException(sql);
        }
        this.columnCountValidated = true;
    }

    protected int getColumnCount(ResultSet resultSet) throws SQLException {
        ResultSetMetaData resultSetMeta = resultSet.getMetaData();
        int columnCount = resultSetMeta.getColumnCount();
        if (columnCount == 2) {
            String columnName = resultSetMeta.getColumnLabel(2).toLowerCase();
            return "doma_rownumber_".equals(columnName) ? 1 : 2;
        }
        return columnCount;
    }
}

