/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.expr.node;

import org.seasar.doma.internal.expr.node.ExpressionLocation;
import org.seasar.doma.internal.expr.node.ExpressionNode;
import org.seasar.doma.internal.expr.node.ExpressionNodeVisitor;
import org.seasar.doma.internal.expr.node.LogicalBinaryOperatorNode;
import org.seasar.doma.internal.util.AssertionUtil;

public class AndOperatorNode
implements LogicalBinaryOperatorNode {
    protected static final int PRIORITY = 20;
    protected final ExpressionLocation location;
    protected final String expression;
    protected ExpressionNode leftNode;
    protected ExpressionNode rightNode;

    public AndOperatorNode(ExpressionLocation location, String expression) {
        AssertionUtil.assertNotNull((Object)location, (Object)expression);
        this.location = location;
        this.expression = expression;
    }

    @Override
    public ExpressionNode getLeftNode() {
        return this.leftNode;
    }

    public void setLeftNode(ExpressionNode leftNode) {
        this.leftNode = leftNode;
    }

    @Override
    public ExpressionNode getRightNode() {
        return this.rightNode;
    }

    public void setRightNode(ExpressionNode rightNode) {
        this.rightNode = rightNode;
    }

    @Override
    public int getPriority() {
        return 20;
    }

    @Override
    public <R, P> R accept(ExpressionNodeVisitor<R, P> visitor, P p) {
        return visitor.visitAndOperatorNode(this, p);
    }

    @Override
    public ExpressionLocation getLocation() {
        return this.location;
    }

    @Override
    public String getExpression() {
        return this.expression;
    }

    public String toString() {
        return String.format("%s %s %s", this.leftNode, this.expression, this.rightNode);
    }
}

