/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.mirror;

import java.util.Map;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import org.seasar.doma.Entity;
import org.seasar.doma.internal.apt.AptIllegalStateException;
import org.seasar.doma.internal.apt.util.AnnotationValueUtil;
import org.seasar.doma.internal.apt.util.ElementUtil;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.jdbc.entity.NamingType;

public class EntityMirror {
    protected final AnnotationMirror annotationMirror;
    protected AnnotationValue listener;
    protected AnnotationValue naming;

    public EntityMirror(AnnotationMirror annotationMirror) {
        this.annotationMirror = annotationMirror;
    }

    public AnnotationMirror getAnnotationMirror() {
        return this.annotationMirror;
    }

    public AnnotationValue getListener() {
        return this.listener;
    }

    public AnnotationValue getNaming() {
        return this.naming;
    }

    public TypeMirror getListenerValue() {
        TypeMirror result = AnnotationValueUtil.toType(this.listener);
        if (result == null) {
            throw new AptIllegalStateException("listener");
        }
        return result;
    }

    public NamingType getNamingValue() {
        VariableElement enumConstant = AnnotationValueUtil.toEnumConstant(this.naming);
        if (enumConstant == null) {
            throw new AptIllegalStateException("naming");
        }
        return NamingType.valueOf(enumConstant.getSimpleName().toString());
    }

    public static EntityMirror newInstance(TypeElement clazz, ProcessingEnvironment env) {
        AssertionUtil.assertNotNull(env);
        AnnotationMirror annotationMirror = ElementUtil.getAnnotationMirror(clazz, Entity.class, env);
        if (annotationMirror == null) {
            return null;
        }
        EntityMirror result = new EntityMirror(annotationMirror);
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : env.getElementUtils().getElementValuesWithDefaults(annotationMirror).entrySet()) {
            String name = entry.getKey().getSimpleName().toString();
            AnnotationValue value = entry.getValue();
            if ("listener".equals(name)) {
                result.listener = value;
                continue;
            }
            if (!"naming".equals(name)) continue;
            result.naming = value;
        }
        return result;
    }
}

