/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.mirror;

import java.util.Map;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.ExecutableElement;
import org.seasar.doma.Delete;
import org.seasar.doma.internal.apt.mirror.ModifyMirror;
import org.seasar.doma.internal.apt.util.ElementUtil;
import org.seasar.doma.internal.util.AssertionUtil;

public class DeleteMirror
extends ModifyMirror {
    protected DeleteMirror(AnnotationMirror annotationMirror) {
        super(annotationMirror);
    }

    public static DeleteMirror newInstance(ExecutableElement method, ProcessingEnvironment env) {
        AssertionUtil.assertNotNull(env);
        AnnotationMirror annotationMirror = ElementUtil.getAnnotationMirror(method, Delete.class, env);
        if (annotationMirror == null) {
            return null;
        }
        DeleteMirror result = new DeleteMirror(annotationMirror);
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : env.getElementUtils().getElementValuesWithDefaults(annotationMirror).entrySet()) {
            String name = entry.getKey().getSimpleName().toString();
            AnnotationValue value = entry.getValue();
            if ("sqlFile".equals(name)) {
                result.sqlFile = value;
                continue;
            }
            if ("queryTimeout".equals(name)) {
                result.queryTimeout = value;
                continue;
            }
            if ("ignoreVersion".equals(name)) {
                result.ignoreVersion = value;
                continue;
            }
            if (!"suppressOptimisticLockException".equals(name)) continue;
            result.suppressOptimisticLockException = value;
        }
        return result;
    }
}

