/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.meta;

import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import org.seasar.doma.GeneratedValue;
import org.seasar.doma.Id;
import org.seasar.doma.SequenceGenerator;
import org.seasar.doma.TableGenerator;
import org.seasar.doma.Version;
import org.seasar.doma.internal.apt.AptException;
import org.seasar.doma.internal.apt.AptIllegalStateException;
import org.seasar.doma.internal.apt.meta.EntityMeta;
import org.seasar.doma.internal.apt.meta.EntityPropertyMeta;
import org.seasar.doma.internal.apt.meta.IdentityIdGeneratorMeta;
import org.seasar.doma.internal.apt.meta.SequenceIdGeneratorMeta;
import org.seasar.doma.internal.apt.meta.TableIdGeneratorMeta;
import org.seasar.doma.internal.apt.mirror.ColumnMirror;
import org.seasar.doma.internal.apt.mirror.SequenceGeneratorMirror;
import org.seasar.doma.internal.apt.mirror.TableGeneratorMirror;
import org.seasar.doma.internal.apt.type.BasicType;
import org.seasar.doma.internal.apt.type.DomainType;
import org.seasar.doma.internal.apt.util.ElementUtil;
import org.seasar.doma.internal.apt.util.TypeMirrorUtil;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.message.Message;
import org.seasar.doma.message.MessageResource;

public class EntityPropertyMetaFactory {
    protected final ProcessingEnvironment env;

    public EntityPropertyMetaFactory(ProcessingEnvironment env) {
        AssertionUtil.assertNotNull(env);
        this.env = env;
    }

    public EntityPropertyMeta createEntityPropertyMeta(VariableElement fieldElement, EntityMeta entityMeta) {
        AssertionUtil.assertNotNull((Object)fieldElement, (Object)entityMeta);
        TypeElement entityElement = ElementUtil.toTypeElement(fieldElement.getEnclosingElement(), this.env);
        if (entityElement == null) {
            throw new AptIllegalStateException(fieldElement.toString());
        }
        EntityPropertyMeta propertyMeta = new EntityPropertyMeta(entityElement, fieldElement, entityMeta.getNamingType(), entityElement.equals(entityMeta.getEntityElement()), this.env);
        this.doName(propertyMeta, fieldElement, entityMeta);
        this.doId(propertyMeta, fieldElement, entityMeta);
        this.doVersion(propertyMeta, fieldElement, entityMeta);
        this.doColumn(propertyMeta, fieldElement, entityMeta);
        this.doDataType(propertyMeta, fieldElement, entityMeta);
        return propertyMeta;
    }

    protected void doId(EntityPropertyMeta propertyMeta, VariableElement fieldElement, EntityMeta entityMeta) {
        Id id = fieldElement.getAnnotation(Id.class);
        if (id == null) {
            GeneratedValue generatedValue = fieldElement.getAnnotation(GeneratedValue.class);
            if (generatedValue == null) {
                this.validateSequenceGeneratorNotExistent(propertyMeta, fieldElement, entityMeta);
                this.validateTableGeneratorNotExistent(propertyMeta, fieldElement, entityMeta);
                return;
            }
            throw new AptException((MessageResource)Message.DOMA4033, this.env, (Element)fieldElement, new Object[0]);
        }
        propertyMeta.setId(true);
        GeneratedValue generatedValue = fieldElement.getAnnotation(GeneratedValue.class);
        if (generatedValue == null) {
            this.validateSequenceGeneratorNotExistent(propertyMeta, fieldElement, entityMeta);
            this.validateTableGeneratorNotExistent(propertyMeta, fieldElement, entityMeta);
            return;
        }
        if (entityMeta.hasGeneratedIdPropertyMeta()) {
            throw new AptException((MessageResource)Message.DOMA4037, this.env, (Element)fieldElement, new Object[0]);
        }
        TypeMirror boxedType = TypeMirrorUtil.boxIfPrimitive(fieldElement.asType(), this.env);
        if (!TypeMirrorUtil.isAssignable(boxedType, Number.class, this.env)) {
            throw new AptException((MessageResource)Message.DOMA4095, this.env, (Element)fieldElement, new Object[0]);
        }
        switch (generatedValue.strategy()) {
            case IDENTITY: {
                this.doIdentityIdGeneratorMeta(propertyMeta, fieldElement, entityMeta);
                break;
            }
            case SEQUENCE: {
                this.doSequenceIdGeneratorMeta(propertyMeta, fieldElement, entityMeta);
                break;
            }
            case TABLE: {
                this.doTableIdGeneratorMeta(propertyMeta, fieldElement, entityMeta);
                break;
            }
            default: {
                AssertionUtil.assertUnreachable();
            }
        }
    }

    protected void validateSequenceGeneratorNotExistent(EntityPropertyMeta propertyMeta, VariableElement fieldElement, EntityMeta entityMeta) {
        SequenceGenerator sequenceGenerator = fieldElement.getAnnotation(SequenceGenerator.class);
        if (sequenceGenerator != null) {
            throw new AptException((MessageResource)Message.DOMA4030, this.env, (Element)fieldElement, new Object[0]);
        }
    }

    protected void validateTableGeneratorNotExistent(EntityPropertyMeta propertyMeta, VariableElement fieldElement, EntityMeta entityMeta) {
        TableGenerator tableGenerator = fieldElement.getAnnotation(TableGenerator.class);
        if (tableGenerator != null) {
            throw new AptException((MessageResource)Message.DOMA4031, this.env, (Element)fieldElement, new Object[0]);
        }
    }

    protected void doIdentityIdGeneratorMeta(EntityPropertyMeta propertyMeta, VariableElement fieldElement, EntityMeta entityMeta) {
        propertyMeta.setIdGeneratorMeta(new IdentityIdGeneratorMeta());
    }

    protected void doSequenceIdGeneratorMeta(EntityPropertyMeta propertyMeta, VariableElement fieldElement, EntityMeta entityMeta) {
        SequenceGeneratorMirror sequenceGeneratorMirror = SequenceGeneratorMirror.newInstance(fieldElement, this.env);
        if (sequenceGeneratorMirror == null) {
            throw new AptException((MessageResource)Message.DOMA4034, this.env, (Element)fieldElement, new Object[0]);
        }
        this.validateSequenceIdGenerator(propertyMeta, fieldElement, sequenceGeneratorMirror);
        SequenceIdGeneratorMeta idGeneratorMeta = new SequenceIdGeneratorMeta(sequenceGeneratorMirror);
        propertyMeta.setIdGeneratorMeta(idGeneratorMeta);
    }

    protected void validateSequenceIdGenerator(EntityPropertyMeta propertyMeta, VariableElement fieldElement, SequenceGeneratorMirror sequenceGeneratorMirror) {
        TypeElement typeElement = TypeMirrorUtil.toTypeElement(sequenceGeneratorMirror.getImplementerValue(), this.env);
        if (typeElement == null) {
            throw new AptIllegalStateException("failed to convert to TypeElement");
        }
        if (typeElement.getModifiers().contains((Object)Modifier.ABSTRACT)) {
            throw new AptException((MessageResource)Message.DOMA4170, this.env, (Element)fieldElement, sequenceGeneratorMirror.getAnnotationMirror(), sequenceGeneratorMirror.getImplementer(), typeElement.getQualifiedName());
        }
        ExecutableElement constructor = ElementUtil.getNoArgConstructor(typeElement, this.env);
        if (constructor == null || !constructor.getModifiers().contains((Object)Modifier.PUBLIC)) {
            throw new AptException((MessageResource)Message.DOMA4171, this.env, (Element)fieldElement, sequenceGeneratorMirror.getAnnotationMirror(), sequenceGeneratorMirror.getImplementer(), typeElement.getQualifiedName());
        }
    }

    protected void doTableIdGeneratorMeta(EntityPropertyMeta propertyMeta, VariableElement fieldElement, EntityMeta entityMeta) {
        TableGeneratorMirror tableGeneratorMirror = TableGeneratorMirror.newInstance(fieldElement, this.env);
        if (tableGeneratorMirror == null) {
            throw new AptException((MessageResource)Message.DOMA4035, this.env, (Element)fieldElement, new Object[0]);
        }
        this.validateTableIdGenerator(propertyMeta, fieldElement, tableGeneratorMirror);
        TableIdGeneratorMeta idGeneratorMeta = new TableIdGeneratorMeta(tableGeneratorMirror);
        propertyMeta.setIdGeneratorMeta(idGeneratorMeta);
    }

    protected void validateTableIdGenerator(EntityPropertyMeta propertyMeta, VariableElement fieldElement, TableGeneratorMirror tableGeneratorMirror) {
        TypeElement typeElement = TypeMirrorUtil.toTypeElement(tableGeneratorMirror.getImplementerValue(), this.env);
        if (typeElement == null) {
            throw new AptIllegalStateException("failed to convert to TypeElement");
        }
        if (typeElement.getModifiers().contains((Object)Modifier.ABSTRACT)) {
            throw new AptException((MessageResource)Message.DOMA4168, this.env, (Element)fieldElement, tableGeneratorMirror.getAnnotationMirror(), tableGeneratorMirror.getImplementer(), typeElement.getQualifiedName());
        }
        ExecutableElement constructor = ElementUtil.getNoArgConstructor(typeElement, this.env);
        if (constructor == null || !constructor.getModifiers().contains((Object)Modifier.PUBLIC)) {
            throw new AptException((MessageResource)Message.DOMA4169, this.env, (Element)fieldElement, tableGeneratorMirror.getAnnotationMirror(), tableGeneratorMirror.getImplementer(), typeElement.getQualifiedName());
        }
    }

    protected void doName(EntityPropertyMeta propertyMeta, VariableElement fieldElement, EntityMeta entityMeta) {
        String name = fieldElement.getSimpleName().toString();
        if (name.startsWith("__")) {
            throw new AptException((MessageResource)Message.DOMA4025, this.env, (Element)fieldElement, "__");
        }
        propertyMeta.setName(name);
    }

    protected void doVersion(EntityPropertyMeta propertyMeta, VariableElement fieldElement, EntityMeta entityMeta) {
        Version version = fieldElement.getAnnotation(Version.class);
        if (version != null) {
            if (entityMeta.hasVersionPropertyMeta()) {
                throw new AptException((MessageResource)Message.DOMA4024, this.env, (Element)fieldElement, new Object[0]);
            }
            TypeMirror boxedType = TypeMirrorUtil.boxIfPrimitive(fieldElement.asType(), this.env);
            if (!TypeMirrorUtil.isAssignable(boxedType, Number.class, this.env)) {
                throw new AptException((MessageResource)Message.DOMA4093, this.env, (Element)fieldElement, new Object[0]);
            }
            propertyMeta.setVersion(true);
        }
    }

    protected void doColumn(EntityPropertyMeta propertyMeta, VariableElement fieldElement, EntityMeta entityMeta) {
        ColumnMirror columnMirror = ColumnMirror.newInstance(fieldElement, this.env);
        if (columnMirror == null) {
            return;
        }
        if (propertyMeta.isId() || propertyMeta.isVersion()) {
            if (!columnMirror.getInsertableValue()) {
                throw new AptException((MessageResource)Message.DOMA4088, this.env, (Element)fieldElement, columnMirror.getAnnotationMirror(), columnMirror.getInsertable(), new Object[0]);
            }
            if (!columnMirror.getUpdatableValue()) {
                throw new AptException((MessageResource)Message.DOMA4089, this.env, (Element)fieldElement, columnMirror.getAnnotationMirror(), columnMirror.getUpdatable(), new Object[0]);
            }
        }
        propertyMeta.setColumnMirror(columnMirror);
    }

    protected void doDataType(EntityPropertyMeta propertyMeta, VariableElement fieldElement, EntityMeta entityMeta) {
        TypeMirror type = fieldElement.asType();
        DomainType domainType = DomainType.newInstance(type, this.env);
        if (domainType != null) {
            propertyMeta.setDataType(domainType);
        } else {
            BasicType basicType = BasicType.newInstance(type, this.env);
            if (basicType != null) {
                propertyMeta.setDataType(basicType);
            } else {
                throw new AptException((MessageResource)Message.DOMA4096, this.env, (Element)fieldElement, type);
            }
        }
    }

    protected boolean isNumber(TypeMirror typeMirror) {
        return TypeMirrorUtil.isAssignable(typeMirror, Number.class, this.env);
    }
}

