/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.meta;

import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import org.seasar.doma.In;
import org.seasar.doma.InOut;
import org.seasar.doma.Out;
import org.seasar.doma.ResultSet;
import org.seasar.doma.internal.apt.AptException;
import org.seasar.doma.internal.apt.meta.AbstractQueryMeta;
import org.seasar.doma.internal.apt.meta.AbstractQueryMetaFactory;
import org.seasar.doma.internal.apt.meta.AutoModuleQueryMeta;
import org.seasar.doma.internal.apt.meta.BasicInOutParameterMeta;
import org.seasar.doma.internal.apt.meta.BasicInParameterMeta;
import org.seasar.doma.internal.apt.meta.BasicListParameterMeta;
import org.seasar.doma.internal.apt.meta.BasicOutParameterMeta;
import org.seasar.doma.internal.apt.meta.CallableSqlParameterMeta;
import org.seasar.doma.internal.apt.meta.DaoMeta;
import org.seasar.doma.internal.apt.meta.DomainInOutParameterMeta;
import org.seasar.doma.internal.apt.meta.DomainInParameterMeta;
import org.seasar.doma.internal.apt.meta.DomainListParameterMeta;
import org.seasar.doma.internal.apt.meta.DomainOutParameterMeta;
import org.seasar.doma.internal.apt.meta.EntityListParameterMeta;
import org.seasar.doma.internal.apt.meta.MapListParameterMeta;
import org.seasar.doma.internal.apt.meta.QueryParameterMeta;
import org.seasar.doma.internal.apt.type.BasicType;
import org.seasar.doma.internal.apt.type.DataType;
import org.seasar.doma.internal.apt.type.DomainType;
import org.seasar.doma.internal.apt.type.EntityType;
import org.seasar.doma.internal.apt.type.IterableType;
import org.seasar.doma.internal.apt.type.MapType;
import org.seasar.doma.internal.apt.type.ReferenceType;
import org.seasar.doma.internal.apt.type.SimpleDataTypeVisitor;
import org.seasar.doma.message.Message;
import org.seasar.doma.message.MessageResource;

public abstract class AutoModuleQueryMetaFactory<M extends AutoModuleQueryMeta>
extends AbstractQueryMetaFactory<M> {
    protected AutoModuleQueryMetaFactory(ProcessingEnvironment env) {
        super(env);
    }

    @Override
    protected void doParameters(M queryMeta, ExecutableElement method, DaoMeta daoMeta) {
        for (VariableElement variableElement : method.getParameters()) {
            QueryParameterMeta parameterMeta = this.createParameterMeta(variableElement);
            ((AbstractQueryMeta)queryMeta).addParameterMeta(parameterMeta);
            CallableSqlParameterMeta callableSqlParameterMeta = this.createParameterMeta(parameterMeta);
            ((AutoModuleQueryMeta)queryMeta).addCallableSqlParameterMeta(callableSqlParameterMeta);
            if (!parameterMeta.isBindable()) continue;
            ((AbstractQueryMeta)queryMeta).addBindableParameterType(parameterMeta.getName(), parameterMeta.getType());
        }
    }

    protected CallableSqlParameterMeta createParameterMeta(QueryParameterMeta parameterMeta) {
        if (parameterMeta.isAnnotated(ResultSet.class)) {
            return this.createResultSetParameterMeta(parameterMeta);
        }
        if (parameterMeta.isAnnotated(In.class)) {
            return this.createInParameterMeta(parameterMeta);
        }
        if (parameterMeta.isAnnotated(Out.class)) {
            return this.createOutParameterMeta(parameterMeta);
        }
        if (parameterMeta.isAnnotated(InOut.class)) {
            return this.createInOutParameterMeta(parameterMeta);
        }
        throw new AptException((MessageResource)Message.DOMA4066, this.env, (Element)parameterMeta.getElement(), new Object[0]);
    }

    protected CallableSqlParameterMeta createResultSetParameterMeta(final QueryParameterMeta parameterMeta) {
        IterableType iterableType = parameterMeta.getDataType().accept(new SimpleDataTypeVisitor<IterableType, Void, RuntimeException>(){

            @Override
            protected IterableType defaultAction(DataType type, Void p) throws RuntimeException {
                throw new AptException((MessageResource)Message.DOMA4062, AutoModuleQueryMetaFactory.this.env, (Element)parameterMeta.getElement(), new Object[0]);
            }

            @Override
            public IterableType visitIterableType(IterableType dataType, Void p) throws RuntimeException {
                if (!dataType.isList()) {
                    this.defaultAction((DataType)dataType, p);
                }
                return dataType;
            }
        }, null);
        return iterableType.getElementType().accept(new SimpleDataTypeVisitor<CallableSqlParameterMeta, Void, RuntimeException>(){

            @Override
            protected CallableSqlParameterMeta defaultAction(DataType type, Void p) throws RuntimeException {
                throw new AptException((MessageResource)Message.DOMA4186, AutoModuleQueryMetaFactory.this.env, (Element)parameterMeta.getElement(), type.getTypeName());
            }

            @Override
            public CallableSqlParameterMeta visitEntityType(EntityType dataType, Void p) throws RuntimeException {
                if (dataType.isAbstract()) {
                    throw new AptException((MessageResource)Message.DOMA4157, AutoModuleQueryMetaFactory.this.env, (Element)parameterMeta.getElement(), dataType.getTypeName());
                }
                return new EntityListParameterMeta(parameterMeta.getName(), dataType);
            }

            @Override
            public CallableSqlParameterMeta visitMapType(MapType dataType, Void p) throws RuntimeException {
                return new MapListParameterMeta(parameterMeta.getName(), dataType);
            }

            @Override
            public CallableSqlParameterMeta visitBasicType(BasicType dataType, Void p) throws RuntimeException {
                return new BasicListParameterMeta(parameterMeta.getName(), dataType);
            }

            @Override
            public CallableSqlParameterMeta visitDomainType(DomainType dataType, Void p) throws RuntimeException {
                return new DomainListParameterMeta(parameterMeta.getName(), dataType);
            }
        }, null);
    }

    protected CallableSqlParameterMeta createInParameterMeta(final QueryParameterMeta parameterMeta) {
        return parameterMeta.getDataType().accept(new SimpleDataTypeVisitor<CallableSqlParameterMeta, Void, RuntimeException>(){

            @Override
            protected CallableSqlParameterMeta defaultAction(DataType type, Void p) throws RuntimeException {
                throw new AptException((MessageResource)Message.DOMA4101, AutoModuleQueryMetaFactory.this.env, (Element)parameterMeta.getElement(), parameterMeta.getType());
            }

            @Override
            public CallableSqlParameterMeta visitBasicType(BasicType dataType, Void p) throws RuntimeException {
                return new BasicInParameterMeta(parameterMeta.getName(), dataType);
            }

            @Override
            public CallableSqlParameterMeta visitDomainType(DomainType dataType, Void p) throws RuntimeException {
                return new DomainInParameterMeta(parameterMeta.getName(), dataType);
            }
        }, null);
    }

    protected CallableSqlParameterMeta createOutParameterMeta(final QueryParameterMeta parameterMeta) {
        final ReferenceType referenceType = parameterMeta.getDataType().accept(new SimpleDataTypeVisitor<ReferenceType, Void, RuntimeException>(){

            @Override
            protected ReferenceType defaultAction(DataType type, Void p) throws RuntimeException {
                throw new AptException((MessageResource)Message.DOMA4098, AutoModuleQueryMetaFactory.this.env, (Element)parameterMeta.getElement(), new Object[0]);
            }

            @Override
            public ReferenceType visitReferenceType(ReferenceType dataType, Void p) throws RuntimeException {
                return dataType;
            }
        }, null);
        return referenceType.getReferentType().accept(new SimpleDataTypeVisitor<CallableSqlParameterMeta, Void, RuntimeException>(){

            @Override
            protected CallableSqlParameterMeta defaultAction(DataType type, Void p) throws RuntimeException {
                throw new AptException((MessageResource)Message.DOMA4100, AutoModuleQueryMetaFactory.this.env, (Element)parameterMeta.getElement(), referenceType.getReferentTypeMirror());
            }

            @Override
            public CallableSqlParameterMeta visitBasicType(BasicType dataType, Void p) throws RuntimeException {
                return new BasicOutParameterMeta(parameterMeta.getName(), dataType);
            }

            @Override
            public CallableSqlParameterMeta visitDomainType(DomainType dataType, Void p) throws RuntimeException {
                return new DomainOutParameterMeta(parameterMeta.getName(), dataType);
            }
        }, null);
    }

    protected CallableSqlParameterMeta createInOutParameterMeta(final QueryParameterMeta parameterMeta) {
        final ReferenceType referenceType = parameterMeta.getDataType().accept(new SimpleDataTypeVisitor<ReferenceType, Void, RuntimeException>(){

            @Override
            protected ReferenceType defaultAction(DataType type, Void p) throws RuntimeException {
                throw new AptException((MessageResource)Message.DOMA4111, AutoModuleQueryMetaFactory.this.env, (Element)parameterMeta.getElement(), new Object[0]);
            }

            @Override
            public ReferenceType visitReferenceType(ReferenceType dataType, Void p) throws RuntimeException {
                return dataType;
            }
        }, null);
        return referenceType.getReferentType().accept(new SimpleDataTypeVisitor<CallableSqlParameterMeta, Void, RuntimeException>(){

            @Override
            protected CallableSqlParameterMeta defaultAction(DataType type, Void p) throws RuntimeException {
                throw new AptException((MessageResource)Message.DOMA4100, AutoModuleQueryMetaFactory.this.env, (Element)parameterMeta.getElement(), referenceType.getReferentTypeMirror());
            }

            @Override
            public CallableSqlParameterMeta visitBasicType(BasicType dataType, Void p) throws RuntimeException {
                return new BasicInOutParameterMeta(parameterMeta.getName(), dataType);
            }

            @Override
            public CallableSqlParameterMeta visitDomainType(DomainType dataType, Void p) throws RuntimeException {
                return new DomainInOutParameterMeta(parameterMeta.getName(), dataType);
            }
        }, null);
    }
}

