/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.meta;

import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import org.seasar.doma.internal.apt.AptException;
import org.seasar.doma.internal.apt.meta.AutoFunctionQueryMeta;
import org.seasar.doma.internal.apt.meta.AutoModuleQueryMetaFactory;
import org.seasar.doma.internal.apt.meta.BasicListResultParameterMeta;
import org.seasar.doma.internal.apt.meta.BasicResultParameterMeta;
import org.seasar.doma.internal.apt.meta.DaoMeta;
import org.seasar.doma.internal.apt.meta.DomainListResultParameterMeta;
import org.seasar.doma.internal.apt.meta.DomainResultParameterMeta;
import org.seasar.doma.internal.apt.meta.EntityListResultParameterMeta;
import org.seasar.doma.internal.apt.meta.MapListResultParameterMeta;
import org.seasar.doma.internal.apt.meta.QueryKind;
import org.seasar.doma.internal.apt.meta.QueryMeta;
import org.seasar.doma.internal.apt.meta.QueryReturnMeta;
import org.seasar.doma.internal.apt.meta.ResultParameterMeta;
import org.seasar.doma.internal.apt.mirror.FunctionMirror;
import org.seasar.doma.internal.apt.type.BasicType;
import org.seasar.doma.internal.apt.type.DataType;
import org.seasar.doma.internal.apt.type.DomainType;
import org.seasar.doma.internal.apt.type.EntityType;
import org.seasar.doma.internal.apt.type.IterableType;
import org.seasar.doma.internal.apt.type.MapType;
import org.seasar.doma.internal.apt.type.SimpleDataTypeVisitor;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.message.Message;
import org.seasar.doma.message.MessageResource;

public class AutoFunctionQueryMetaFactory
extends AutoModuleQueryMetaFactory<AutoFunctionQueryMeta> {
    public AutoFunctionQueryMetaFactory(ProcessingEnvironment env) {
        super(env);
    }

    @Override
    public QueryMeta createQueryMeta(ExecutableElement method, DaoMeta daoMeta) {
        AssertionUtil.assertNotNull((Object)method, (Object)daoMeta);
        FunctionMirror functionMirror = FunctionMirror.newInstance(method, this.env);
        if (functionMirror == null) {
            return null;
        }
        AutoFunctionQueryMeta queryMeta = new AutoFunctionQueryMeta(method);
        queryMeta.setFunctionMirror(functionMirror);
        queryMeta.setQueryKind(QueryKind.AUTO_FUNCTION);
        this.doTypeParameters(queryMeta, method, daoMeta);
        this.doReturnType(queryMeta, method, daoMeta);
        this.doParameters(queryMeta, method, daoMeta);
        this.doThrowTypes(queryMeta, method, daoMeta);
        return queryMeta;
    }

    @Override
    protected void doReturnType(AutoFunctionQueryMeta queryMeta, ExecutableElement method, DaoMeta daoMeta) {
        QueryReturnMeta returnMeta = this.createReturnMeta(method);
        queryMeta.setReturnMeta(returnMeta);
        ResultParameterMeta resultParameterMeta = this.createCallableSqlResultParameterMeta(returnMeta);
        queryMeta.setResultParameterMeta(resultParameterMeta);
    }

    protected ResultParameterMeta createCallableSqlResultParameterMeta(final QueryReturnMeta returnMeta) {
        return returnMeta.getDataType().accept(new SimpleDataTypeVisitor<ResultParameterMeta, Void, RuntimeException>(){

            @Override
            protected ResultParameterMeta defaultAction(DataType type, Void p) throws RuntimeException {
                throw new AptException((MessageResource)Message.DOMA4063, AutoFunctionQueryMetaFactory.this.env, (Element)returnMeta.getElement(), returnMeta.getType());
            }

            @Override
            public ResultParameterMeta visitBasicType(BasicType dataType, Void p) throws RuntimeException {
                return new BasicResultParameterMeta(dataType);
            }

            @Override
            public ResultParameterMeta visitDomainType(DomainType dataType, Void p) throws RuntimeException {
                return new DomainResultParameterMeta(dataType);
            }

            @Override
            public ResultParameterMeta visitIterableType(IterableType dataType, Void p) throws RuntimeException {
                if (!dataType.isList()) {
                    this.defaultAction((DataType)dataType, p);
                }
                return dataType.getElementType().accept(new SimpleDataTypeVisitor<ResultParameterMeta, Void, RuntimeException>(){

                    @Override
                    protected ResultParameterMeta defaultAction(DataType dataType, Void p) throws RuntimeException {
                        throw new AptException((MessageResource)Message.DOMA4065, AutoFunctionQueryMetaFactory.this.env, (Element)returnMeta.getElement(), dataType.getTypeName());
                    }

                    @Override
                    public ResultParameterMeta visitBasicType(BasicType dataType, Void p) throws RuntimeException {
                        return new BasicListResultParameterMeta(dataType);
                    }

                    @Override
                    public ResultParameterMeta visitDomainType(DomainType dataType, Void p) throws RuntimeException {
                        return new DomainListResultParameterMeta(dataType);
                    }

                    @Override
                    public ResultParameterMeta visitEntityType(EntityType dataType, Void p) throws RuntimeException {
                        if (dataType.isAbstract()) {
                            throw new AptException((MessageResource)Message.DOMA4156, AutoFunctionQueryMetaFactory.this.env, (Element)returnMeta.getElement(), dataType.getTypeName());
                        }
                        return new EntityListResultParameterMeta(dataType);
                    }

                    @Override
                    public ResultParameterMeta visitMapType(MapType dataType, Void p) throws RuntimeException {
                        return new MapListResultParameterMeta(dataType);
                    }
                }, p);
            }
        }, null);
    }
}

