/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.meta;

import java.util.List;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import org.seasar.doma.internal.apt.AptException;
import org.seasar.doma.internal.apt.meta.AbstractQueryMetaFactory;
import org.seasar.doma.internal.apt.meta.AutoBatchModifyQueryMeta;
import org.seasar.doma.internal.apt.meta.DaoMeta;
import org.seasar.doma.internal.apt.meta.QueryKind;
import org.seasar.doma.internal.apt.meta.QueryMeta;
import org.seasar.doma.internal.apt.meta.QueryParameterMeta;
import org.seasar.doma.internal.apt.meta.QueryReturnMeta;
import org.seasar.doma.internal.apt.mirror.BatchDeleteMirror;
import org.seasar.doma.internal.apt.mirror.BatchInsertMirror;
import org.seasar.doma.internal.apt.mirror.BatchModifyMirror;
import org.seasar.doma.internal.apt.mirror.BatchUpdateMirror;
import org.seasar.doma.internal.apt.type.DataType;
import org.seasar.doma.internal.apt.type.EntityType;
import org.seasar.doma.internal.apt.type.IterableType;
import org.seasar.doma.internal.apt.type.SimpleDataTypeVisitor;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.message.Message;
import org.seasar.doma.message.MessageResource;

public class AutoBatchModifyQueryMetaFactory
extends AbstractQueryMetaFactory<AutoBatchModifyQueryMeta> {
    public AutoBatchModifyQueryMetaFactory(ProcessingEnvironment env) {
        super(env);
    }

    @Override
    public QueryMeta createQueryMeta(ExecutableElement method, DaoMeta daoMeta) {
        AssertionUtil.assertNotNull((Object)method, (Object)daoMeta);
        AutoBatchModifyQueryMeta queryMeta = this.createAutoBatchModifyQueryMeta(method, daoMeta);
        if (queryMeta == null) {
            return null;
        }
        this.doTypeParameters(queryMeta, method, daoMeta);
        this.doReturnType(queryMeta, method, daoMeta);
        this.doParameters(queryMeta, method, daoMeta);
        this.doThrowTypes(queryMeta, method, daoMeta);
        return queryMeta;
    }

    protected AutoBatchModifyQueryMeta createAutoBatchModifyQueryMeta(ExecutableElement method, DaoMeta daoMeta) {
        AutoBatchModifyQueryMeta queryMeta = new AutoBatchModifyQueryMeta(method);
        BatchModifyMirror batchModifyMirror = BatchInsertMirror.newInstance(method, this.env);
        if (batchModifyMirror != null && !batchModifyMirror.getSqlFileValue()) {
            queryMeta.setBatchModifyMirror(batchModifyMirror);
            queryMeta.setQueryKind(QueryKind.AUTO_BATCH_INSERT);
            return queryMeta;
        }
        batchModifyMirror = BatchUpdateMirror.newInstance(method, this.env);
        if (batchModifyMirror != null && !batchModifyMirror.getSqlFileValue()) {
            queryMeta.setBatchModifyMirror(batchModifyMirror);
            queryMeta.setQueryKind(QueryKind.AUTO_BATCH_UPDATE);
            return queryMeta;
        }
        batchModifyMirror = BatchDeleteMirror.newInstance(method, this.env);
        if (batchModifyMirror != null && !batchModifyMirror.getSqlFileValue()) {
            queryMeta.setBatchModifyMirror(batchModifyMirror);
            queryMeta.setQueryKind(QueryKind.AUTO_BATCH_DELETE);
            return queryMeta;
        }
        return null;
    }

    @Override
    protected void doReturnType(AutoBatchModifyQueryMeta queryMeta, ExecutableElement method, DaoMeta daoMeta) {
        QueryReturnMeta returnMeta = this.createReturnMeta(method);
        if (!returnMeta.isPrimitiveIntArray()) {
            throw new AptException((MessageResource)Message.DOMA4040, this.env, (Element)returnMeta.getElement(), new Object[0]);
        }
        queryMeta.setReturnMeta(returnMeta);
    }

    @Override
    protected void doParameters(AutoBatchModifyQueryMeta queryMeta, final ExecutableElement method, DaoMeta daoMeta) {
        List<? extends VariableElement> parameters = method.getParameters();
        int size = parameters.size();
        if (size != 1) {
            throw new AptException((MessageResource)Message.DOMA4002, this.env, (Element)method, new Object[0]);
        }
        QueryParameterMeta parameterMeta = this.createParameterMeta(parameters.get(0));
        IterableType iterableType = parameterMeta.getDataType().accept(new SimpleDataTypeVisitor<IterableType, Void, RuntimeException>(){

            @Override
            protected IterableType defaultAction(DataType dataType, Void p) throws RuntimeException {
                throw new AptException((MessageResource)Message.DOMA4042, AutoBatchModifyQueryMetaFactory.this.env, (Element)method, new Object[0]);
            }

            @Override
            public IterableType visitIterableType(IterableType dataType, Void p) throws RuntimeException {
                return dataType;
            }
        }, null);
        EntityType entityType = iterableType.getElementType().accept(new SimpleDataTypeVisitor<EntityType, Void, RuntimeException>(){

            @Override
            protected EntityType defaultAction(DataType dataType, Void p) throws RuntimeException {
                throw new AptException((MessageResource)Message.DOMA4043, AutoBatchModifyQueryMetaFactory.this.env, (Element)method, new Object[0]);
            }

            @Override
            public EntityType visitEntityType(EntityType dataType, Void p) throws RuntimeException {
                return dataType;
            }
        }, null);
        queryMeta.setEntityType(entityType);
        queryMeta.setEntitiesParameterName(parameterMeta.getName());
        queryMeta.addParameterMeta(parameterMeta);
        if (parameterMeta.isBindable()) {
            queryMeta.addBindableParameterType(parameterMeta.getName(), entityType.getTypeMirror());
        }
        BatchModifyMirror batchModifyMirror = queryMeta.getBatchModifyMirror();
        this.validateEntityPropertyNames(entityType.getTypeMirror(), method, batchModifyMirror.getAnnotationMirror(), batchModifyMirror.getInclude(), batchModifyMirror.getExclude());
    }
}

