/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt;

import java.util.Formatter;
import org.seasar.doma.internal.util.AssertionUtil;

public class Printer {
    protected static final String INDENT_SPACE = "    ";
    protected StringBuilder indent = new StringBuilder();
    protected final Formatter formatter;

    public Printer(Appendable appendable) {
        AssertionUtil.assertNotNull(appendable);
        this.formatter = new Formatter(appendable);
    }

    public void p(String format, Object ... args) {
        this.formatter.format(this.indent + format, args);
    }

    public void pp(String format, Object ... args) {
        this.formatter.format(format, args);
    }

    public void indent() {
        this.indent.append(INDENT_SPACE);
    }

    public void unindent() {
        if (this.indent.length() >= INDENT_SPACE.length()) {
            this.indent.setLength(this.indent.length() - INDENT_SPACE.length());
        }
    }

    public void close() {
        this.formatter.close();
    }
}

