/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt;

import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.tools.Diagnostic;
import org.seasar.doma.internal.apt.AptException;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.message.MessageResource;

public final class Notifier {
    public static void debug(ProcessingEnvironment env, MessageResource messageResource, Object ... args) {
        AssertionUtil.assertNotNull((Object)env, (Object)messageResource, (Object)args);
        Messager messager = env.getMessager();
        messager.printMessage(Diagnostic.Kind.OTHER, messageResource.getMessage(args));
    }

    public static void debug(ProcessingEnvironment env, CharSequence message) {
        AssertionUtil.assertNotNull((Object)env, (Object)message);
        Messager messager = env.getMessager();
        messager.printMessage(Diagnostic.Kind.OTHER, message);
    }

    public static void notify(ProcessingEnvironment env, Diagnostic.Kind kind, MessageResource messageResource, Object ... args) {
        AssertionUtil.assertNotNull((Object)env, (Object)messageResource, (Object)args);
        Messager messager = env.getMessager();
        messager.printMessage(kind, messageResource.getMessage(args));
    }

    public static void notify(ProcessingEnvironment env, Diagnostic.Kind kind, MessageResource messageResource, Element element, Object ... args) {
        AssertionUtil.assertNotNull((Object)env, (Object)kind, (Object)element, (Object)args);
        Messager messager = env.getMessager();
        messager.printMessage(kind, messageResource.getMessage(args), element);
    }

    public static void notify(ProcessingEnvironment env, AptException e) {
        AssertionUtil.assertNotNull((Object)env, (Object)e);
        Messager messager = env.getMessager();
        messager.printMessage(e.getKind(), e.getMessage(), e.getElement(), e.getAnnotationMirror(), e.getAnnotationValue());
    }
}

