/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt;

import java.io.IOException;
import java.util.Set;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;
import javax.tools.Diagnostic;
import org.seasar.doma.internal.apt.AptException;
import org.seasar.doma.internal.apt.AptIllegalStateException;
import org.seasar.doma.internal.apt.Generator;
import org.seasar.doma.internal.apt.Notifier;
import org.seasar.doma.internal.apt.Options;
import org.seasar.doma.internal.apt.meta.TypeElementMeta;
import org.seasar.doma.internal.apt.meta.TypeElementMetaFactory;
import org.seasar.doma.internal.util.IOUtil;
import org.seasar.doma.message.Message;
import org.seasar.doma.message.MessageResource;

public abstract class AbstractProcessor<M extends TypeElementMeta>
extends javax.annotation.processing.AbstractProcessor {
    protected AbstractProcessor() {
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (roundEnv.processingOver()) {
            return true;
        }
        for (TypeElement typeElement : annotations) {
            TypeElementMetaFactory<M> factory = this.createTypeElementMetaFactory();
            for (TypeElement entityElement : ElementFilter.typesIn(roundEnv.getElementsAnnotatedWith(typeElement))) {
                if (Options.isDebugEnabled(this.processingEnv)) {
                    Notifier.debug(this.processingEnv, Message.DOMA4090, this.getClass().getName(), entityElement.getQualifiedName());
                }
                try {
                    M meta = factory.createTypeElementMeta(entityElement);
                    if (!meta.isError()) {
                        this.generate(entityElement, meta);
                    }
                }
                catch (AptException e) {
                    Notifier.notify(this.processingEnv, e);
                }
                catch (AptIllegalStateException e) {
                    Notifier.notify(this.processingEnv, Diagnostic.Kind.ERROR, (MessageResource)Message.DOMA4039, entityElement, new Object[0]);
                    throw e;
                }
                catch (RuntimeException e) {
                    Notifier.notify(this.processingEnv, Diagnostic.Kind.ERROR, (MessageResource)Message.DOMA4016, entityElement, new Object[0]);
                    throw e;
                }
                if (!Options.isDebugEnabled(this.processingEnv)) continue;
                Notifier.debug(this.processingEnv, Message.DOMA4091, this.getClass().getName(), entityElement.getQualifiedName());
            }
        }
        return true;
    }

    protected abstract TypeElementMetaFactory<M> createTypeElementMetaFactory();

    protected void generate(TypeElement typeElement, M meta) {
        Generator generator = null;
        try {
            generator = this.createGenerator(typeElement, meta);
            generator.generate();
        }
        catch (IOException e) {
            try {
                throw new AptException((MessageResource)Message.DOMA4011, this.processingEnv, (Element)typeElement, e, typeElement.getQualifiedName(), e);
            }
            catch (Throwable throwable) {
                IOUtil.close(generator);
                throw throwable;
            }
        }
        IOUtil.close(generator);
    }

    protected abstract Generator createGenerator(TypeElement var1, M var2) throws IOException;
}

