/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.io.protocol;

import com.google.appengine.repackaged.com.google.io.protocol.MessageVisitor;
import com.google.appengine.repackaged.com.google.io.protocol.ProtocolMessage;
import com.google.appengine.repackaged.com.google.io.protocol.ProtocolSink;
import com.google.appengine.repackaged.com.google.io.protocol.ProtocolSource;
import com.google.appengine.repackaged.com.google.io.protocol.ProtocolType;
import com.google.appengine.repackaged.com.google.io.protocol.proto.ProtocolDescriptor;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RawMessage
extends ProtocolMessage<RawMessage> {
    public static final RawMessage IMMUTABLE_DEFAULT_INSTANCE = new RawMessage();
    private ByteBuffer byteBuffer = ByteBuffer.allocate(128).order(ByteOrder.LITTLE_ENDIAN);
    private static ProtocolType cachedClassProtocolType;

    @Override
    public RawMessage getDefaultInstanceForType() {
        return IMMUTABLE_DEFAULT_INSTANCE;
    }

    public ByteBuffer contents() {
        ByteBuffer buf = this.byteBuffer.asReadOnlyBuffer();
        buf.flip();
        return buf.order(ByteOrder.LITTLE_ENDIAN);
    }

    @Override
    public boolean isInitialized() {
        return true;
    }

    @Override
    public int encodingSize() {
        return this.byteBuffer.position();
    }

    @Override
    public int maxEncodingSize() {
        return this.encodingSize();
    }

    @Override
    public void clear() {
        this.byteBuffer.clear();
    }

    @Override
    public RawMessage newInstance() {
        return new RawMessage();
    }

    @Override
    public void outputTo(ProtocolSink sink) {
        sink.putBytes(this.byteBuffer.array(), 0, this.byteBuffer.position());
    }

    private void ensureCapacity(int minCapacity) {
        if (this.byteBuffer.capacity() < minCapacity) {
            int newCapacity = Math.max(this.byteBuffer.capacity() * 2, Integer.highestOneBit(minCapacity) * 2);
            ByteBuffer newByteBuffer = ByteBuffer.allocate(newCapacity).order(ByteOrder.LITTLE_ENDIAN);
            newByteBuffer.put(this.byteBuffer.array(), 0, this.byteBuffer.position());
            this.byteBuffer = newByteBuffer;
        }
    }

    @Override
    public boolean merge(ProtocolSource source) {
        int remaining = source.remaining();
        this.ensureCapacity(this.byteBuffer.position() + remaining);
        source.getBytes(this.byteBuffer.array(), this.byteBuffer.position(), remaining);
        this.byteBuffer.position(this.byteBuffer.position() + remaining);
        return true;
    }

    @Override
    public RawMessage mergeFrom(RawMessage other) {
        if (other == this) {
            throw new IllegalArgumentException("Cannot merge from the same instance");
        }
        this.ensureCapacity(this.byteBuffer.position() + other.byteBuffer.position());
        this.byteBuffer.put(other.byteBuffer.array(), 0, other.byteBuffer.position());
        return this;
    }

    public void mergeFromOther(ProtocolMessage proto) {
        this.mergeFrom(proto.toByteArray());
    }

    public void mergeTo(ProtocolMessage proto) {
        ByteBuffer reference = this.byteBuffer.duplicate();
        reference.flip();
        proto.mergeFrom(reference);
    }

    public void mergeToOther(ProtocolMessage proto) {
        this.mergeTo(proto);
    }

    @Override
    public boolean equalsIgnoreUninterpreted(RawMessage that) {
        return this.equals(that, true);
    }

    @Override
    public boolean equals(RawMessage that) {
        return this.equals(that, false);
    }

    @Override
    public boolean equals(RawMessage other, boolean uninterpreted) {
        if (other == this) {
            return true;
        }
        if (other == null || other.byteBuffer.position() != this.byteBuffer.position()) {
            return false;
        }
        int size = this.byteBuffer.position();
        for (int i = 0; i < size; ++i) {
            if (this.byteBuffer.get(i) == other.byteBuffer.get(i)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equals(Object that) {
        return that instanceof RawMessage && this.equals((RawMessage)that);
    }

    @Override
    public int hashCode() {
        return 104729 + this.byteBuffer.hashCode();
    }

    @Override
    public ProtocolType getProtocolType() {
        return RawMessage.getClassProtocolType();
    }

    private static synchronized ProtocolType getClassProtocolType() {
        if (cachedClassProtocolType == null) {
            String name = RawMessage.class.getName();
            String fileName = "java/" + name.replace('.', '/') + ".java";
            final ProtocolDescriptor descriptor = new ProtocolDescriptor().setName(name).setFilename(fileName);
            cachedClassProtocolType = new ProtocolType(RawMessage.class, null, new ProtocolType.FieldType[0]){

                @Override
                protected void visitInternal(ProtocolMessage message, ProtocolType.Visitor visitor, Iterable<ProtocolType.FieldType> fields) {
                    RawMessage rawMessage = (RawMessage)message;
                    visitor.visitRawMessage(rawMessage.contents());
                }

                @Override
                protected void visitInternal(ProtocolMessage message, MessageVisitor visitor, Iterable<ProtocolType.FieldType> fields) {
                    visitor.visitRawMessage(((RawMessage)message).contents());
                }

                @Override
                public ProtocolDescriptor getProtocolDescriptor() {
                    return descriptor;
                }
            };
        }
        return cachedClassProtocolType;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.writeInt(this.byteBuffer.position());
        s.write(this.byteBuffer.array(), 0, this.byteBuffer.position());
    }

    private void readObject(ObjectInputStream s) throws IOException {
        int size = s.readInt();
        if (this.byteBuffer == null) {
            this.byteBuffer = ByteBuffer.allocate(size);
        } else {
            this.ensureCapacity(this.byteBuffer.position() + size);
        }
        s.read(this.byteBuffer.array(), this.byteBuffer.position(), size);
        this.byteBuffer.position(this.byteBuffer.position() + size);
    }
}

