/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.base;

import com.google.appengine.repackaged.com.google.common.base.Joiner;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.common.annotations.GwtCompatible;
import java.io.IOException;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GwtCompatible
public final class Join {
    private Join() {
    }

    public static String join(String delimiter, Iterable<? extends Object> tokens) {
        return Joiner.on(delimiter).useForNull("null").join(tokens);
    }

    public static String join(String delimiter, @Nullable Object[] tokens) {
        return Joiner.on(delimiter).useForNull("null").join(tokens);
    }

    public static String join(String delimiter, @Nullable Object firstToken, Object ... otherTokens) {
        return Joiner.on(delimiter).useForNull("null").join(Join.iterable(firstToken, otherTokens));
    }

    public static String join(String delimiter, Iterator<?> tokens) {
        StringBuilder sb = new StringBuilder();
        Join.join(sb, delimiter, tokens);
        return sb.toString();
    }

    public static String join(String keyValueSeparator, String entryDelimiter, Map<?, ?> map) {
        return Joiner.on(entryDelimiter).useForNull("null").withKeyValueSeparator(keyValueSeparator).join(map);
    }

    public static <T extends Appendable> T join(T appendable, String delimiter, Iterable<?> tokens) {
        try {
            return Joiner.on(delimiter).useForNull("null").appendTo(appendable, tokens);
        }
        catch (IOException e) {
            throw new JoinException(e);
        }
    }

    public static <T extends Appendable> T join(T appendable, String delimiter, Object[] tokens) {
        return Join.join(appendable, delimiter, Arrays.asList(tokens));
    }

    public static <T extends Appendable> T join(T appendable, String delimiter, @Nullable Object firstToken, Object ... otherTokens) {
        return Join.join(appendable, delimiter, Join.iterable(firstToken, otherTokens));
    }

    public static <T extends Appendable> T join(T appendable, String delimiter, Iterator<?> tokens) {
        Preconditions.checkNotNull(appendable);
        Preconditions.checkNotNull(delimiter);
        if (tokens.hasNext()) {
            try {
                Join.appendOneToken(appendable, tokens.next());
                while (tokens.hasNext()) {
                    appendable.append(delimiter);
                    Join.appendOneToken(appendable, tokens.next());
                }
            }
            catch (IOException e) {
                throw new JoinException(e);
            }
        }
        return appendable;
    }

    public static <T extends Appendable> T join(T appendable, String keyValueSeparator, String entryDelimiter, Map<?, ?> map) {
        try {
            return Joiner.on(entryDelimiter).useForNull("null").withKeyValueSeparator(keyValueSeparator).appendTo(appendable, map);
        }
        catch (IOException e) {
            throw new JoinException(e);
        }
    }

    private static void appendOneToken(Appendable appendable, Object token) throws IOException {
        appendable.append(Join.toCharSequence(token));
    }

    private static CharSequence toCharSequence(Object token) {
        return token instanceof CharSequence ? (CharSequence)token : String.valueOf(token);
    }

    private static Iterable<Object> iterable(final @Nullable Object first, final @Nullable Object[] rest) {
        Preconditions.checkNotNull(rest);
        return new AbstractList<Object>(){

            @Override
            public int size() {
                return rest.length + 1;
            }

            @Override
            @Nullable
            public Object get(int index) {
                return index == 0 ? first : rest[index - 1];
            }
        };
    }

    public static class JoinException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        private JoinException(IOException cause) {
            super(cause);
        }
    }
}

