/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api;

import com.google.apphosting.api.ApiProxy;
import java.util.Map;

public final class NamespaceManager {
    private static final NamespaceTranslator translator = new DefaultTranslator();
    private static final String DEFAULT_API_NAMESPACE_KEY = NamespaceManager.class.getName() + ".default_api_namespace_key";

    public static void set(String newNamespace) {
        ApiProxy.Environment environment = ApiProxy.getCurrentEnvironment();
        environment.getAttributes().put(DEFAULT_API_NAMESPACE_KEY, newNamespace);
    }

    public static void reset() {
        ApiProxy.Environment environment = ApiProxy.getCurrentEnvironment();
        environment.getAttributes().remove(DEFAULT_API_NAMESPACE_KEY);
    }

    public static String get() {
        ApiProxy.Environment environment = ApiProxy.getCurrentEnvironment();
        Map<String, Object> attributes = environment.getAttributes();
        String namespace = (String)attributes.get(DEFAULT_API_NAMESPACE_KEY);
        if (namespace == null) {
            namespace = translator.translate(environment.getRequestNamespace());
            attributes.put(DEFAULT_API_NAMESPACE_KEY, namespace);
        }
        return namespace;
    }

    private NamespaceManager() {
    }

    private static class DefaultTranslator
    implements NamespaceTranslator {
        private DefaultTranslator() {
        }

        public String translate(String requestNamespace) {
            return "";
        }
    }

    private static interface NamespaceTranslator {
        public String translate(String var1);
    }
}

