/*
 * Decompiled with CFR 0.152.
 */
package org.slim3.gen.task;

import java.io.IOException;
import java.util.StringTokenizer;
import javax.xml.xpath.XPathExpressionException;
import org.slim3.gen.desc.ModelDesc;
import org.slim3.gen.generator.Generator;
import org.slim3.gen.generator.ModelGenerator;
import org.slim3.gen.generator.ModelTestCaseGenerator;
import org.slim3.gen.message.MessageCode;
import org.slim3.gen.message.MessageFormatter;
import org.slim3.gen.task.AbstractGenJavaFileTask;
import org.slim3.gen.task.ClassNameBuilder;
import org.slim3.gen.task.JavaFile;
import org.slim3.gen.task.WebConfig;

public class GenModelTask
extends AbstractGenJavaFileTask {
    protected String packageName;
    protected String testCaseSuperclassName = "org.slim3.tester.AppEngineTestCase";
    protected String modelDefinition;
    protected String modelClassNameProperty;

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public void setTestCaseSuperclassName(String testCaseSuperclassName) {
        this.testCaseSuperclassName = testCaseSuperclassName;
    }

    public void setModelDefinition(String modelDefinition) {
        this.modelDefinition = modelDefinition;
    }

    public void setModelClassNameProperty(String modelClassNameProperty) {
        this.modelClassNameProperty = modelClassNameProperty;
    }

    public void doExecute() throws Exception {
        super.doExecute();
        if (this.modelDefinition == null) {
            throw new IllegalStateException("The modelDefinition parameter is null.");
        }
        if (this.modelClassNameProperty == null) {
            throw new IllegalStateException("The modelClassNameProperty parameter is null.");
        }
        if (this.getProject().getProperty(this.modelClassNameProperty) != null) {
            throw new IllegalStateException(MessageFormatter.getMessage(MessageCode.SLIM3GEN0009, this.modelClassNameProperty));
        }
        ModelDesc modelDesc = this.createModelDesc();
        JavaFile javaFile = this.createJavaFile(modelDesc);
        Generator generator = this.createModelGenerator(modelDesc);
        this.generateJavaFile(generator, javaFile);
        JavaFile testCaseJavaFile = this.createTestCaseJavaFile(modelDesc);
        Generator testCaseGenerator = this.createModelTestCaseGenerator(modelDesc);
        this.generateJavaFile(testCaseGenerator, testCaseJavaFile);
        this.getProject().setNewProperty(this.modelClassNameProperty, modelDesc.getQualifiedName());
    }

    private ModelDesc createModelDesc() throws IOException, XPathExpressionException {
        ModelDef modelDef = this.parse(this.modelDefinition);
        ModelDesc modelDesc = new ModelDesc();
        ClassNameBuilder classNameBuilder = new ClassNameBuilder();
        classNameBuilder.append(this.getModelBasePackageName());
        classNameBuilder.append(modelDef.modelRelativeClassName);
        modelDesc.setPackageName(classNameBuilder.getPackageName());
        modelDesc.setSimpleName(classNameBuilder.getSimpleName());
        if (modelDef.modelRelativeSuperclassName == null) {
            modelDesc.setSuperclassName("java.lang.Object");
        } else {
            ClassNameBuilder superclassNameBuilder = new ClassNameBuilder();
            superclassNameBuilder.append(this.getModelBasePackageName());
            superclassNameBuilder.append(modelDef.modelRelativeSuperclassName);
            modelDesc.setSuperclassName(superclassNameBuilder.getQualifiedName());
        }
        modelDesc.setTestCaseSuperclassName(this.testCaseSuperclassName);
        return modelDesc;
    }

    protected ModelDef parse(String input) {
        StringTokenizer tokenizer = new StringTokenizer(input, " ");
        int count = tokenizer.countTokens();
        if (count == 1) {
            ModelDef modelDef = new ModelDef();
            modelDef.modelRelativeClassName = tokenizer.nextToken();
            return modelDef;
        }
        if (count == 3) {
            ModelDef parsedText = new ModelDef();
            parsedText.modelRelativeClassName = tokenizer.nextToken();
            String keyword = tokenizer.nextToken();
            if (!"extends".equals(keyword)) {
                throw new RuntimeException(MessageFormatter.getSimpleMessage(MessageCode.SLIM3GEN0012, keyword, input));
            }
            parsedText.modelRelativeSuperclassName = tokenizer.nextToken();
            return parsedText;
        }
        throw new RuntimeException(MessageFormatter.getSimpleMessage(MessageCode.SLIM3GEN0013, input, count));
    }

    protected String getModelBasePackageName() throws IOException, XPathExpressionException {
        if (this.packageName != null) {
            return this.packageName;
        }
        WebConfig config = this.createWebConfig();
        StringBuilder buf = new StringBuilder();
        buf.append(config.getRootPackageName());
        if (config.isGWTServiceServletDefined()) {
            buf.append(".");
            buf.append("shared");
        }
        buf.append(".");
        buf.append("model");
        return buf.toString();
    }

    protected Generator createModelGenerator(ModelDesc modelDesc) {
        return new ModelGenerator(modelDesc);
    }

    protected Generator createModelTestCaseGenerator(ModelDesc modelDesc) {
        return new ModelTestCaseGenerator(modelDesc);
    }

    protected static class ModelDef {
        protected String modelRelativeClassName;
        protected String modelRelativeSuperclassName;

        protected ModelDef() {
        }
    }
}

