/*
 * Decompiled with CFR 0.152.
 */
package org.slim3.gen.generator;

import org.slim3.gen.desc.ModelDesc;
import org.slim3.gen.generator.Generator;
import org.slim3.gen.printer.Printer;
import org.slim3.gen.util.ClassUtil;

public class ModelTestCaseGenerator
implements Generator {
    protected final ModelDesc modelDesc;

    public ModelTestCaseGenerator(ModelDesc modelDesc) {
        if (modelDesc == null) {
            throw new NullPointerException("The modelDesc parameter is null.");
        }
        this.modelDesc = modelDesc;
    }

    public void generate(Printer p) {
        if (this.modelDesc.getPackageName().length() != 0) {
            p.println("package %s;", this.modelDesc.getPackageName());
            p.println();
        }
        if (!"java.lang.Object".equals(this.modelDesc.getTestCaseSuperclassName())) {
            p.println("import %s;", this.modelDesc.getTestCaseSuperclassName());
        }
        p.println("import %s;", "org.junit.Test");
        p.println("import static %s.*;", "org.junit.Assert");
        p.println("import static %s.*;", "org.hamcrest.CoreMatchers");
        p.println();
        p.print("public class %s%s", this.modelDesc.getSimpleName(), "Test");
        if (!"java.lang.Object".equals(this.modelDesc.getTestCaseSuperclassName())) {
            p.print(" extends %s", ClassUtil.getSimpleName(this.modelDesc.getTestCaseSuperclassName()));
        }
        p.println(" {", new Object[0]);
        p.println();
        p.println("    private %1$s model = new %1$s();", this.modelDesc.getSimpleName());
        p.println();
        p.println("    @%s", ClassUtil.getSimpleName("org.junit.Test"));
        p.println("    public void test() throws Exception {", new Object[0]);
        p.println("        assertThat(model, is(notNullValue()));", new Object[0]);
        p.println("    }", new Object[0]);
        p.println("}", new Object[0]);
    }
}

