/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.labs.taskqueue;

import com.google.appengine.repackaged.com.google.common.collect.Multimap;
import com.google.appengine.repackaged.com.google.io.protocol.MessageAppender;
import com.google.appengine.repackaged.com.google.io.protocol.Protocol;
import com.google.appengine.repackaged.com.google.io.protocol.ProtocolMessage;
import com.google.appengine.repackaged.com.google.io.protocol.ProtocolSink;
import com.google.appengine.repackaged.com.google.io.protocol.ProtocolSource;
import com.google.appengine.repackaged.com.google.io.protocol.ProtocolSupport;
import com.google.appengine.repackaged.com.google.io.protocol.ProtocolType;
import com.google.appengine.repackaged.com.google.io.protocol.UninterpretedTags;
import java.nio.charset.Charset;
import java.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Transaction
extends ProtocolMessage<Transaction> {
    private static final long serialVersionUID = 1L;
    private long handle_ = 0L;
    private byte[] app_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
    private UninterpretedTags uninterpreted;
    private int optional_0_;
    public static final Transaction IMMUTABLE_DEFAULT_INSTANCE = new Transaction(){
        private static final long serialVersionUID = 1L;

        public Transaction clearHandle() {
            return this;
        }

        public Transaction setHandle(long x) {
            ProtocolSupport.unsupportedOperation();
            return this;
        }

        public Transaction clearApp() {
            return this;
        }

        public Transaction setAppAsBytes(byte[] x) {
            ProtocolSupport.unsupportedOperation();
            return this;
        }

        public Transaction setApp(String v) {
            ProtocolSupport.unsupportedOperation();
            return this;
        }

        public Transaction setApp(String v, Charset cs) {
            ProtocolSupport.unsupportedOperation();
            return this;
        }

        public Transaction mergeFrom(Transaction that) {
            ProtocolSupport.unsupportedOperation();
            return this;
        }

        public boolean merge(ProtocolSource source) {
            ProtocolSupport.unsupportedOperation();
            return false;
        }

        public Transaction freeze() {
            return this;
        }

        public Transaction unfreeze() {
            ProtocolSupport.unsupportedOperation();
            return this;
        }

        public boolean isFrozen() {
            return true;
        }
    };
    public static final int khandle = 1;
    public static final int kapp = 2;
    public static final String[] text = new String[3];
    public static final int[] types;
    public static final String style = "";
    public static final String style_content_type = "";

    public final long getHandle() {
        return this.handle_;
    }

    public final boolean hasHandle() {
        return (this.optional_0_ & 1) != 0;
    }

    public Transaction clearHandle() {
        this.optional_0_ &= 0xFFFFFFFE;
        this.handle_ = 0L;
        return this;
    }

    public Transaction setHandle(long x) {
        this.optional_0_ |= 1;
        this.handle_ = x;
        return this;
    }

    public final byte[] getAppAsBytes() {
        return this.app_;
    }

    public final boolean hasApp() {
        return (this.optional_0_ & 2) != 0;
    }

    public Transaction clearApp() {
        this.optional_0_ &= 0xFFFFFFFD;
        this.app_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
        return this;
    }

    public Transaction setAppAsBytes(byte[] x) {
        this.optional_0_ |= 2;
        this.app_ = x;
        return this;
    }

    public final String getApp() {
        return ProtocolSupport.toStringUtf8((byte[])this.app_);
    }

    public Transaction setApp(String v) {
        if (v == null) {
            throw new NullPointerException();
        }
        this.optional_0_ |= 2;
        this.app_ = ProtocolSupport.toBytesUtf8((String)v);
        return this;
    }

    public final String getApp(Charset cs) {
        return ProtocolSupport.toString((byte[])this.app_, (Charset)cs);
    }

    public Transaction setApp(String v, Charset cs) {
        if (v == null) {
            throw new NullPointerException();
        }
        this.optional_0_ |= 2;
        this.app_ = ProtocolSupport.toBytes((String)v, (Charset)cs);
        return this;
    }

    public Transaction mergeFrom(Transaction that) {
        assert (that != this);
        int this_t0 = this.optional_0_;
        int that_t0 = that.optional_0_;
        if ((that_t0 & 1) != 0) {
            this_t0 |= 1;
            this.handle_ = that.handle_;
        }
        if ((that_t0 & 2) != 0) {
            this_t0 |= 2;
            this.app_ = that.app_;
        }
        if ((that_t0 & 4) != 0) {
            this_t0 |= 4;
            if (this.uninterpreted == null) {
                this.uninterpreted = new UninterpretedTags();
            }
            this.uninterpreted.putAll((Multimap)that.uninterpreted);
        }
        this.optional_0_ = this_t0;
        return this;
    }

    public boolean equalsIgnoreUninterpreted(Transaction that) {
        return this.equals(that, true);
    }

    public boolean equals(Transaction that) {
        return this.equals(that, false);
    }

    public boolean equals(Transaction that, boolean ignoreUninterpreted) {
        if (that == null) {
            return false;
        }
        if (that == this) {
            return true;
        }
        int this_t0 = this.optional_0_;
        int that_t0 = that.optional_0_;
        if (!ignoreUninterpreted ? this_t0 != that_t0 : (this_t0 & 0xFFFFFFFB) != (that_t0 & 0xFFFFFFFB)) {
            return false;
        }
        if ((this_t0 & 1) != 0 && this.handle_ != that.handle_) {
            return false;
        }
        if ((this_t0 & 2) != 0 && !Arrays.equals(this.app_, that.app_)) {
            return false;
        }
        return ignoreUninterpreted || (this_t0 & 4) == 0 || this.uninterpreted.equals(that.uninterpreted);
    }

    public boolean equals(Object that) {
        return that instanceof Transaction && this.equals((Transaction)((Object)that));
    }

    public int hashCode() {
        int hash = 1975120663;
        int this_t0 = this.optional_0_;
        hash = hash * 31 + ((this_t0 & 1) != 0 ? ProtocolSupport.hashCode((long)this.handle_) : -113);
        hash = hash * 31 + ((this_t0 & 2) != 0 ? Arrays.hashCode(this.app_) : -113);
        if ((this_t0 & 4) != 0) {
            hash = hash * 31 + this.uninterpreted.hashCode();
        }
        return hash;
    }

    public boolean isInitialized() {
        int this_t0 = this.optional_0_;
        return (this_t0 & 1) == 1;
    }

    public int encodingSize() {
        int n = 9;
        int this_t0 = this.optional_0_;
        if ((this_t0 & 2) != 0) {
            n += 1 + Protocol.stringSize((int)this.app_.length);
        }
        return (this_t0 & 4) != 0 ? n + this.uninterpreted.encodingSize() : n;
    }

    public int maxEncodingSize() {
        int n = 9;
        int this_t0 = this.optional_0_;
        if ((this_t0 & 2) != 0) {
            n += 6 + this.app_.length;
        }
        return (this_t0 & 4) != 0 ? n + this.uninterpreted.maxEncodingSize() : n;
    }

    public MessageAppender getMessageAppender() {
        if (this.uninterpreted == null) {
            this.optional_0_ |= 4;
            this.uninterpreted = new UninterpretedTags();
        }
        return this.uninterpreted;
    }

    public void clear() {
        this.optional_0_ = 0;
        this.handle_ = 0L;
        this.app_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
        this.uninterpreted = null;
    }

    public Transaction newInstance() {
        return new Transaction();
    }

    public ProtocolType getProtocolType() {
        return StaticHolder.protocolType;
    }

    public void outputTo(ProtocolSink sink) {
        sink.putByte((byte)9);
        sink.putLong(this.handle_);
        int this_t0 = this.optional_0_;
        if ((this_t0 & 2) != 0) {
            sink.putByte((byte)18);
            sink.putPrefixedData(this.app_);
        }
        if ((this_t0 & 4) != 0) {
            this.uninterpreted.put(sink);
        }
    }

    public boolean merge(ProtocolSource source) {
        boolean result = true;
        int this_t0 = this.optional_0_;
        block5: while (source.hasRemaining()) {
            int tt = source.getVarInt();
            switch (tt) {
                case 0: {
                    result = false;
                    break block5;
                }
                case 9: {
                    this.handle_ = source.getLong();
                    this_t0 |= 1;
                    continue block5;
                }
                case 18: {
                    this.app_ = source.getPrefixedData();
                    this_t0 |= 2;
                    continue block5;
                }
                default: {
                    if (this.uninterpreted == null) {
                        this.uninterpreted = new UninterpretedTags();
                    }
                    this.uninterpreted.put((Object)tt, (Object)source.getUninterpreted(tt));
                    this_t0 |= 4;
                    continue block5;
                }
            }
        }
        this.optional_0_ = this_t0;
        return result;
    }

    public Transaction getDefaultInstanceForType() {
        return IMMUTABLE_DEFAULT_INSTANCE;
    }

    public Transaction freeze() {
        this.app_ = ProtocolSupport.freezeString((byte[])this.app_);
        return this;
    }

    static {
        Transaction.text[0] = "ErrorCode";
        Transaction.text[1] = "handle";
        Transaction.text[2] = "app";
        types = new int[3];
        Arrays.fill(types, 6);
        Transaction.types[0] = 0;
        Transaction.types[1] = 1;
        Transaction.types[2] = 2;
    }

    private static class StaticHolder {
        private static final ProtocolType protocolType = new ProtocolType(Transaction.class, "Z'apphosting/datastore/datastore_v3.proto\n#apphosting_datastore_v3.Transaction\u0013\u001a\u0006handle \u0001(\u00010\u00068\u0002\u0014\u0013\u001a\u0003app \u0002(\u00020\t8\u0001\u0014", new ProtocolType.FieldType[]{new ProtocolType.FieldType("handle", "handle", 1, 0, ProtocolType.FieldBaseType.FIXED64, ProtocolType.Presence.REQUIRED), new ProtocolType.FieldType("app", "app", 2, 1, ProtocolType.FieldBaseType.STRING, ProtocolType.Presence.OPTIONAL)});

        private StaticHolder() {
        }
    }
}

