/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.aptina.commons.message;

import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Set;
import org.seasar.aptina.commons.message.EnumMessageCode;

public class EnumMessageResourceBundle<T extends Enum<T>>
extends ResourceBundle {
    protected final Class<T> enumClass;
    protected final int locale;

    public static <T extends Enum<T>> ResourceBundle getBundle(Class<T> enumClass) throws IllegalStateException {
        return ResourceBundle.getBundle(enumClass.getName(), new EnumMessageResourceBundleControl<T>(enumClass));
    }

    public static <T extends Enum<T>> ResourceBundle getBundle(Class<T> enumClass, Locale locale) throws IllegalStateException {
        return ResourceBundle.getBundle(enumClass.getName(), locale, new EnumMessageResourceBundleControl<T>(enumClass));
    }

    public static <T extends Enum<T>> ResourceBundle getBundleNoFallback(Class<T> enumClass) {
        return ResourceBundle.getBundle(enumClass.getName(), new EnumMessageResourceBundleControl<T>(enumClass, false));
    }

    public static <T extends Enum<T>> ResourceBundle getBundleNoFallback(Class<T> enumClass, Locale locale) {
        return ResourceBundle.getBundle(enumClass.getName(), locale, new EnumMessageResourceBundleControl<T>(enumClass, false));
    }

    public EnumMessageResourceBundle(Class<T> enumClass, int locale) {
        this.enumClass = enumClass;
        this.locale = locale;
    }

    @Override
    public Enumeration<String> getKeys() {
        Set<String> keys = this.handleKeySet();
        if (this.parent != null) {
            Enumeration<String> it = this.parent.getKeys();
            while (it.hasMoreElements()) {
                String key = it.nextElement();
                keys.add(key);
            }
        }
        return Collections.enumeration(keys);
    }

    @Override
    protected Set<String> handleKeySet() {
        Enum[] codes = (Enum[])this.enumClass.getEnumConstants();
        HashSet<String> keys = new HashSet<String>(codes.length);
        for (Enum code : codes) {
            if (((EnumMessageCode)((Object)code)).getMessageFormat(this.locale) == null) continue;
            keys.add(code.name());
        }
        return keys;
    }

    @Override
    protected Object handleGetObject(String key) {
        try {
            T code = Enum.valueOf(this.enumClass, key);
            return ((EnumMessageCode)code).getMessageFormat(this.locale);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    static class EnumMessageResourceBundleControl<T extends Enum<T>>
    extends ResourceBundle.Control {
        protected final Class<T> enumClass;
        protected final boolean noFallback;
        protected final Locale[] supportedLocales;

        public EnumMessageResourceBundleControl(Class<T> enumClass) {
            this(enumClass, false);
        }

        public EnumMessageResourceBundleControl(Class<T> enumClass, boolean noFallback) {
            this.enumClass = enumClass;
            this.noFallback = noFallback;
            this.supportedLocales = this.getSupportedLocales(enumClass);
        }

        @Override
        public List<String> getFormats(String baseName) {
            return FORMAT_CLASS;
        }

        @Override
        public ResourceBundle newBundle(String baseName, Locale locale, String format, ClassLoader loader, boolean reload) throws IllegalAccessException, InstantiationException, IOException {
            for (int i = 0; i < this.supportedLocales.length; ++i) {
                if (!this.supportedLocales[i].equals(locale)) continue;
                return new EnumMessageResourceBundle<T>(this.enumClass, i);
            }
            return null;
        }

        @Override
        public Locale getFallbackLocale(String baseName, Locale locale) {
            return null;
        }

        protected Locale[] getSupportedLocales(Class<T> enumClass) {
            try {
                Field field = enumClass.getDeclaredField("SUPPORTED_LOCALES");
                field.setAccessible(true);
                if (field != null) {
                    return (Locale[])field.get(null);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new IllegalStateException(enumClass.getName() + " must have " + "SUPPORTED_LOCALES" + " field.");
        }
    }
}

