# Windows PowerShell
# ev[g

param($url, $outDir, $beforeRev, $afterRev, $envPattern)

Set-StrictMode -Version Latest
$PSDefaultParameterValues = @{"ErrorAction"="Stop"}
$ErrorActionPreference = "Stop"
$WarningPreference = "Continue"
$VerbosePreference = "Continue"
$DebugPreference = "Continue"

######################################################################
### ֐`
######################################################################

# gp@o͂B
# return - Ȃ
function U-Write-Usage() {
    Write-Output "gF$psName SVNURL o̓fBNg [-BeforeRev ύXOrW] [-AfterRev ύXナrW] [-EnvPattern ˑp^[]"
    Write-Output "ˑp^[ - ˑt@C肷ۂɎgp鐳K\"
}

# 又sB
# return - Ȃ
function U-Run-Main() {
    if ($afterRev -eq $null) {
        $afterRev = "HEAD"
    }
    
    U-Checkout-Source
    U-Create-DiffList
    U-Copy-DiffFile
    U-Count-Step
}

function U-Checkout-Source() {
    Write-Verbose "`FbNAEgJn ${url}@${afterRev}"
    Invoke-Expression "svn co ${url}@${afterRev} $afterDir"
    
    if ($beforeRev -ne $null) {
        Write-Verbose "`FbNAEgJn ${url}@${beforeRev}"
        Invoke-Expression "svn co ${url}@${beforeRev} $beforeDir"
    }
}

function U-Create-DiffList() {
    Write-Verbose "Xg쐬Jn ${url}@${beforeRev}:${afterRev}"
    
    if ($beforeRev -eq $null) {
        Invoke-Expression "svn list --recursive -r $afterRev $url" | Set-Content -Encoding String $listPath
    } else {
        Invoke-Expression "svn diff -r ${beforeRev}:${afterRev} --summarize ${url}" | %{
            if ($_ -match "^(.+) +(.+)$") {
                $encodedUrl = $matches[2]
                $decodedUrl = [System.Uri]::UnescapeDataString($encodedUrl)
                if ($decodedUrl -match "${url}/(.+)$") {
                    Write-Output $matches[1]
                } elseif ($decodedUrl -match "${url}$") {
                    # o͕sv
                } else {
                    Write-Output "# Warning ͎s $_"
                    Write-Warning "Warning ͎s $_"
                }
            } else {
                Write-Output "# Warning ͎s $_"
                Write-Warning "Warning ͎s $_"
            }
        } | Set-Content -Encoding String $listPath
    }
}

function U-Copy-DiffFile() {
    Write-Verbose "t@CRs[Jn ${url}@${beforeRev}:${afterRev}"
    Get-Content $listPath | ?{
        $_.Trim().Length -ne 0 -and
        $_.Trim() -notmatch "^#"
    } | %{
        $afterPath = "$afterDir\$_"
        $afterDiffPath = "$afterDiffDir\$_"
        if (Test-Path -PathType Leaf $afterPath) {
            $path = $null
            if ($envPattern -ne $null) {
                if (Get-Content $afterPath | Select-String -Quiet $envPattern) {
                    Write-Debug "t@CRs[iˑj $_"
                    $path = "$afterEnvDir\$_"
                }
            }
            if ($path -eq $null) {
                Write-Debug "t@CRs[ $_"
                $path = $afterDiffPath
            }
            New-Item -Force -ItemType File $path | Out-Null
            Copy-Item $afterPath $path
        } elseif (Test-Path -PathType Container $afterPath) {
            Write-Debug "fBNg쐬 $_"
            New-Item -Force -ItemType Directory $afterDiffPath | Out-Null
        } else {
            Write-Warning "XLbv $_"
        }
    }
}

function U-Count-Step() {
    Write-Verbose "\[XXebvvJn ${url}@${beforeRev}:${afterRev}"
    
    New-Item -Force -ItemType Directory $stepDir | Out-Null
    
    # S̃JEg
    #Write-Verbose "ύX\[XJEgieLXg`j"
    #java -cp $jarPath jp.sf.amateras.stepcounter.Main $afterDir -showDirectory=true "-output=${outDir}\AfterStep.txt"
    #Get-Content "${outDir}\AfterStep.txt" | Write-Debug
    Write-Verbose "ύX\[XJEgiCSV`j"
    java -cp $jarPath jp.sf.amateras.stepcounter.Main $afterDir -showDirectory=true -format=csv "-output=${stepDir}\AfterStep.csv"
    Write-Verbose "ύX\[XJEgiExcel`j"
    java -cp $jarPath jp.sf.amateras.stepcounter.Main $afterDir -showDirectory=true -format=excel "-output=${stepDir}\AfterStep.xls"

    # JEg
    if ($beforeRev -ne $null) {
        Write-Verbose "\[XJEgiCSV`j"
        java -cp $jarPath jp.sf.amateras.stepcounter.diffcount.Main $afterDir $beforeDir -format=csv "-output=${stepDir}\DiffStep.csv"
        Write-Verbose "\[XJEgiExcel`j"
        java -cp $jarPath jp.sf.amateras.stepcounter.diffcount.Main $afterDir $beforeDir -format=excel "-output=${stepDir}\DiffStep.xls"
    }
}

######################################################################
### s
######################################################################

###
### O
###

$baseDir = Convert-Path $(Split-Path $MyInvocation.InvocationName -Parent)
$psName = Split-Path $MyInvocation.InvocationName -Leaf
$psBaseName = $psName -replace "\.ps1$", ""
$beforeDir = "${outDir}\before"
$afterDir = "${outDir}\after"
$afterDiffDir = "${outDir}\afterDiff"
$afterEnvDir = "${outDir}\afterEnv"
$stepDir = "${outDir}\step"
$listPath = "${outDir}\DiffList.txt"
$jarPath = "$baseDir\..\stepcounter-3.0.1\eclipse-plugin\jp.sf.amateras.stepcounter\lib\stepcounter-3.0.1-jar-with-dependencies.jar"

Write-Debug "$psName Start"

###
### 又
###

if ($outDir -eq $null) {
    U-Write-Usage
} else {
    U-Run-Main
}

###
### ㏈
###

Write-Debug "$psName End"
