package com.kurukurupapa.tryandroidui.dialog;

import android.app.ListActivity;
import android.graphics.Color;
import android.os.Bundle;
import android.view.View;
import android.widget.ArrayAdapter;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.Toast;

public class ColorDialogActivity extends ListActivity {
	private static final String YAM_COLOR_PICKER_DIALOG = "Y.A.M の 雑記帳: ColorPickerDialog";
	private static final String SIMPLE_COLOR_DIALOG = "SimpleColorDialog";
	private static final String BOX_HSV_COLOR_DIALOG = "BoxHsvColorDialog";

	private static final String[] NAME_ARR = { YAM_COLOR_PICKER_DIALOG,
			SIMPLE_COLOR_DIALOG, BOX_HSV_COLOR_DIALOG };

	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);

		ListAdapter adapter = new ArrayAdapter<String>(this,
				android.R.layout.simple_list_item_1, NAME_ARR);
		setListAdapter(adapter);
	}

	@Override
	protected void onListItemClick(ListView l, View v, int position, long id) {
		super.onListItemClick(l, v, position, id);

		String name = NAME_ARR[position];
		if (name.equals(YAM_COLOR_PICKER_DIALOG)) {
			new ColorPickerDialog(this,
					new ColorPickerDialog.OnColorChangedListener() {
						@Override
						public void colorChanged(int color) {
							showColor(color);
						}
					}, Color.WHITE).show();

		} else if (name.equals(SIMPLE_COLOR_DIALOG)) {
			final SimpleColorDialog dialog = new SimpleColorDialog(this);
			dialog.setTitle("SimpleColorDialog");
			dialog.setOkButton(new SimpleColorDialog.OnColorChangedListener() {
				@Override
				public void onColorChanged(int color) {
					showColor(color);
				}
			});
			dialog.show();

		} else if (name.equals(BOX_HSV_COLOR_DIALOG)) {
			final BoxHsvColorDialog dialog = new BoxHsvColorDialog(this);
			dialog.setTitle(name);
			dialog.setOkButton(new BoxHsvColorDialog.OnColorChangedListener() {
				@Override
				public void onColorChanged(int color) {
					showColor(color);
				}
			});
			dialog.show();

		}
	}

	private void showColor(int color) {
		StringBuilder sb = new StringBuilder();
		sb.append("0x" + Integer.toHexString(Color.red(color)));
		sb.append(",0x" + Integer.toHexString(Color.green(color)));
		sb.append(",0x" + Integer.toHexString(Color.blue(color)));
		Toast.makeText(this, sb.toString(), Toast.LENGTH_LONG).show();
	}
}
