package com.tryandroid.media;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;

import com.tryandroid.R;

import android.content.Context;
import android.os.Environment;

public class CameraUtil {
	private static SimpleDateFormat timestampFormat = new SimpleDateFormat(
			"yyyyMMdd-HHmmss");

	public static File getBaseDir(Context context) {
		File storageDir = Environment.getExternalStorageDirectory();
		File baseDir = new File(new File(storageDir,
				context.getString(R.string.app_name)), "Camera");
		return baseDir;
	}

	public static String getFileName() {
		return "Photo-"
				+ timestampFormat.format(new Date(System.currentTimeMillis()))
				+ ".jpg";
	}

	public static void save(File baseDir, String path, byte[] data)
			throws IOException {
		FileOutputStream fos = null;

		try {
			// ディレクトリ作成
			if (!baseDir.exists()) {
				baseDir.mkdirs();
			}

			// ファイル作成
			fos = new FileOutputStream(path);
			fos.write(data);

		} finally {
			if (fos != null) {
				fos.close();
			}
		}
	}

}
