package com.tryandroid.media;

import com.kurukurupapa.tryandroid.fw.util.LogUtil;
import com.tryandroid.R;

import android.app.Activity;
import android.os.Bundle;
import android.view.SurfaceView;
import android.view.View;

/**
 * カメラ撮影のアクティビティ
 */
public class CameraRecActivity extends Activity {

	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		LogUtil.called();

		// レイアウト
		setContentView(R.layout.camera_rec_activity);
		SurfaceView cameraRecView = (SurfaceView) findViewById(R.id.camera_rec_view);

		// 各種オブジェクト作成
		new CameraRecViewHelper(this, cameraRecView);
	}

	public void onInfoButtonClick(View view) {
		LogUtil.called();

		StringBuilder sb = new StringBuilder();
		sb.append("保存フォルダ：" + CameraUtil.getBaseDir(this) + "\n");
		sb.append("画面をタッチするとカメラ撮影します。");
		new InfoDialogBuilder(this, sb.toString()).show();
	}

}
