/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.aptina.beans.internal;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.tools.Diagnostic;
import org.seasar.aptina.beans.BeanState;
import org.seasar.aptina.beans.Property;
import org.seasar.aptina.beans.internal.BeanInfo;
import org.seasar.aptina.beans.internal.ConstructorInfo;
import org.seasar.aptina.beans.internal.DiagnosticMessageCode;
import org.seasar.aptina.beans.internal.PropertyInfo;
import org.seasar.aptina.commons.message.EnumMessageTextFormatter;
import org.seasar.aptina.commons.util.ClassUtils;
import org.seasar.aptina.commons.util.ElementUtils;
import org.seasar.aptina.commons.util.StringUtils;

public class BeanInfoFactory {
    protected static final Set<Modifier> IGNORE_FIELD_MODIFIERS = new HashSet<Modifier>();
    protected ProcessingEnvironment env;
    protected EnumMessageTextFormatter<DiagnosticMessageCode> messageFormatter;
    protected AnnotationMirror beanStateAnnotation;
    protected boolean hasError;

    public BeanInfoFactory(ProcessingEnvironment env) {
        this.env = env;
        this.messageFormatter = new EnumMessageTextFormatter<DiagnosticMessageCode>(DiagnosticMessageCode.class, env.getLocale());
    }

    public BeanInfo createBeanInfo(TypeElement typeElement) {
        this.beanStateAnnotation = ElementUtils.getAnnotationMirror((Element)typeElement, BeanState.class);
        this.hasError = false;
        BeanInfo beanInfo = this.processType(typeElement);
        if (beanInfo == null) {
            return null;
        }
        for (VariableElement fieldElement : ElementFilter.fieldsIn(typeElement.getEnclosedElements())) {
            PropertyInfo propertyInfo = this.processField(fieldElement);
            if (propertyInfo == null) continue;
            beanInfo.addPropertyInfo(propertyInfo);
        }
        for (ExecutableElement constructorElement : ElementFilter.constructorsIn(typeElement.getEnclosedElements())) {
            ConstructorInfo constructorInfo = this.processConstructor(constructorElement);
            if (constructorInfo == null) continue;
            beanInfo.addConstructor(constructorInfo);
        }
        if (beanInfo.getConstructors().isEmpty()) {
            this.printMessage((Element)typeElement, DiagnosticMessageCode.CTOR0001, new Object[0]);
        }
        for (ExecutableElement methodElement : ElementFilter.methodsIn(typeElement.getEnclosedElements())) {
            this.processMethod(methodElement, beanInfo);
        }
        return this.hasError ? null : beanInfo;
    }

    protected BeanInfo processType(TypeElement typeElement) {
        BeanInfo beanInfo = new BeanInfo();
        switch (typeElement.getKind()) {
            case INTERFACE: {
                this.printMessage((Element)typeElement, this.beanStateAnnotation, DiagnosticMessageCode.CLS0000, new Object[0]);
                return null;
            }
            case ENUM: {
                this.printMessage((Element)typeElement, this.beanStateAnnotation, DiagnosticMessageCode.CLS0001, new Object[0]);
                return null;
            }
            case ANNOTATION_TYPE: {
                this.printMessage((Element)typeElement, this.beanStateAnnotation, DiagnosticMessageCode.CLS0002, new Object[0]);
                return null;
            }
        }
        switch (typeElement.getNestingKind()) {
            case LOCAL: {
                this.printMessage((Element)typeElement, this.beanStateAnnotation, DiagnosticMessageCode.CLS0003, new Object[0]);
                return null;
            }
            case MEMBER: 
            case ANONYMOUS: {
                this.printMessage((Element)typeElement, this.beanStateAnnotation, DiagnosticMessageCode.CLS0004, new Object[0]);
                return null;
            }
        }
        if (typeElement.getModifiers().contains((Object)Modifier.FINAL)) {
            this.printMessage((Element)typeElement, this.beanStateAnnotation, DiagnosticMessageCode.CLS0005, new Object[0]);
            return null;
        }
        if (!typeElement.getModifiers().contains((Object)Modifier.PUBLIC)) {
            this.printMessage((Element)typeElement, this.beanStateAnnotation, DiagnosticMessageCode.CLS0006, new Object[0]);
            return null;
        }
        beanInfo.setComment(this.env.getElementUtils().getDocComment(typeElement));
        String stateClassName = typeElement.getQualifiedName().toString();
        String packageName = ClassUtils.getPackageName(stateClassName);
        beanInfo.setPackageName(packageName);
        beanInfo.setBeanClassName(BeanInfoFactory.toBeanClassName(typeElement.getSimpleName().toString()));
        List<? extends TypeParameterElement> typeParameters = typeElement.getTypeParameters();
        beanInfo.setTypeParameter(ElementUtils.toStringOfTypeParameterDecl(typeParameters));
        beanInfo.setStateClassName(stateClassName + ElementUtils.toStringOfTypeParameterNames(typeParameters));
        BeanState beanState = typeElement.getAnnotation(BeanState.class);
        if (beanState.boundProperties()) {
            beanInfo.setBoundProperties(true);
        }
        if (beanState.constrainedProperties()) {
            beanInfo.setConstrainedProperties(true);
        }
        return beanInfo;
    }

    protected PropertyInfo processField(VariableElement variableElement) {
        PropertyInfo propertyInfo = new PropertyInfo();
        Property property = variableElement.getAnnotation(Property.class);
        Set<Modifier> modifiers = variableElement.getModifiers();
        if (property == null) {
            if (!Collections.disjoint(modifiers, IGNORE_FIELD_MODIFIERS)) {
                return null;
            }
        } else {
            AnnotationMirror propertyAnnotationMirror = ElementUtils.getAnnotationMirror((Element)variableElement, Property.class);
            if (modifiers.contains((Object)Modifier.PRIVATE)) {
                this.printMessage((Element)variableElement, propertyAnnotationMirror, DiagnosticMessageCode.FLD0000, new Object[0]);
                return null;
            }
            if (modifiers.contains((Object)Modifier.PUBLIC)) {
                this.printMessage((Element)variableElement, propertyAnnotationMirror, DiagnosticMessageCode.FLD0001, new Object[0]);
                return null;
            }
            if (modifiers.contains((Object)Modifier.STATIC)) {
                this.printMessage((Element)variableElement, propertyAnnotationMirror, DiagnosticMessageCode.FLD0002, new Object[0]);
                return null;
            }
            switch (property.access()) {
                case NONE: {
                    return null;
                }
                case WRITE_ONLY: {
                    if (!modifiers.contains((Object)Modifier.FINAL)) break;
                    this.printMessage((Element)variableElement, propertyAnnotationMirror, DiagnosticMessageCode.FLD0003, new Object[0]);
                    return null;
                }
            }
        }
        String propertyName = variableElement.getSimpleName().toString();
        String comment = this.env.getElementUtils().getDocComment(variableElement);
        if (comment == null || comment.isEmpty()) {
            propertyInfo.setComment(propertyName);
        } else {
            propertyInfo.setComment(comment.trim());
        }
        propertyInfo.setName(propertyName);
        TypeMirror propertyType = variableElement.asType();
        propertyInfo.setType(((Object)propertyType).toString());
        if (propertyType.getKind() == TypeKind.ARRAY) {
            propertyInfo.setArray(true);
            propertyInfo.setComponentType(((Object)((ArrayType)ArrayType.class.cast(propertyType)).getComponentType()).toString());
        }
        if (property != null) {
            switch (property.access()) {
                case READ_ONLY: {
                    propertyInfo.setWritable(false);
                    break;
                }
                case WRITE_ONLY: {
                    propertyInfo.setReadable(false);
                }
            }
        }
        if (modifiers.contains((Object)Modifier.FINAL)) {
            propertyInfo.setWritable(false);
        }
        return propertyInfo;
    }

    protected ConstructorInfo processConstructor(ExecutableElement executableElement) {
        ConstructorInfo constructorInfo = new ConstructorInfo();
        List<? extends VariableElement> parameters = executableElement.getParameters();
        Set<Modifier> modifiers = executableElement.getModifiers();
        if (parameters.isEmpty() && !modifiers.contains((Object)Modifier.PUBLIC)) {
            this.printMessage((Element)executableElement, DiagnosticMessageCode.CTOR0000, new Object[0]);
        }
        if (modifiers.contains((Object)Modifier.PRIVATE)) {
            return null;
        }
        constructorInfo.setComment(this.env.getElementUtils().getDocComment(executableElement));
        constructorInfo.addModifiers(modifiers);
        constructorInfo.setTypeParameters(ElementUtils.toStringOfTypeParameterDecl(executableElement.getTypeParameters()));
        for (VariableElement variableElement : parameters) {
            constructorInfo.addParameterType(((Object)variableElement.asType()).toString());
            constructorInfo.addParameterName(variableElement.getSimpleName().toString());
        }
        for (TypeMirror typeMirror : executableElement.getThrownTypes()) {
            constructorInfo.addThrownType(((Object)typeMirror).toString());
        }
        return constructorInfo;
    }

    protected void processMethod(ExecutableElement executableElement, BeanInfo beanInfo) {
        PropertyInfo propertyInfo;
        String propertyName;
        String methodName = executableElement.getSimpleName().toString();
        if (methodName.startsWith("is") && methodName.length() > 2 && Character.isUpperCase(methodName.charAt(2)) && executableElement.getParameters().isEmpty()) {
            propertyName = StringUtils.decapitalize(methodName.substring(2));
            propertyInfo = beanInfo.getPropertyInfo(propertyName);
            if (propertyInfo != null) {
                propertyInfo.setReadable(false);
            }
        } else if (methodName.startsWith("get") && methodName.length() > 3 && Character.isUpperCase(methodName.charAt(3)) && executableElement.getParameters().isEmpty() && (propertyInfo = beanInfo.getPropertyInfo(propertyName = StringUtils.decapitalize(methodName.substring(3)))) != null) {
            propertyInfo.setReadable(false);
        }
        if (methodName.startsWith("set") && methodName.length() > 3 && Character.isUpperCase(methodName.charAt(3)) && executableElement.getParameters().size() == 1 && (propertyInfo = beanInfo.getPropertyInfo(propertyName = StringUtils.decapitalize(methodName.substring(3)))) != null) {
            String type = ((Object)executableElement.getParameters().get(0).asType()).toString();
            if (propertyInfo.getType().equals(type)) {
                propertyInfo.setWritable(false);
            }
        }
    }

    protected static String toBeanClassName(String stateClassName) {
        if (stateClassName.startsWith("Abstract")) {
            return stateClassName.substring("Abstract".length());
        }
        if (stateClassName.endsWith("State")) {
            return stateClassName.substring(0, stateClassName.length() - "State".length());
        }
        if (stateClassName.endsWith("Bean")) {
            return stateClassName + "Impl";
        }
        return stateClassName + "Bean";
    }

    protected void printMessage(Element element, DiagnosticMessageCode messageCode, Object ... args) {
        if (messageCode.getKind() == Diagnostic.Kind.ERROR) {
            this.hasError = true;
        }
        this.env.getMessager().printMessage(messageCode.getKind(), this.messageFormatter.getMessage(messageCode, args), element);
    }

    protected void printMessage(Element element, AnnotationMirror annotation, DiagnosticMessageCode messageCode, Object ... args) {
        if (messageCode.getKind() == Diagnostic.Kind.ERROR) {
            this.hasError = true;
        }
        this.env.getMessager().printMessage(messageCode.getKind(), this.messageFormatter.getMessage(messageCode, args), element, annotation);
    }

    static {
        IGNORE_FIELD_MODIFIERS.add(Modifier.STATIC);
        IGNORE_FIELD_MODIFIERS.add(Modifier.PUBLIC);
        IGNORE_FIELD_MODIFIERS.add(Modifier.PRIVATE);
    }
}

