package com.kurukurupapa.tryandroidui.tablelayout;

import android.app.Activity;
import android.os.Bundle;
import android.util.Log;
import android.widget.LinearLayout;
import android.widget.TableLayout;
import android.widget.TableRow;
import android.widget.TextView;

public class TableLayoutActivity extends Activity {
	public final String TAG = "com.kurukurupapa.tryandroidui";

	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);

		LinearLayout linearLayout = new LinearLayout(this);
		linearLayout.setOrientation(LinearLayout.VERTICAL);

		//
		// TableLayout
		//

		TextView textView;
		textView = new TextView(this);
		textView.setText("TableLayout");
		linearLayout.addView(textView);

		createLayoutByTableLayout(linearLayout);

		//
		// LinearLayoutでも同じようなことをしてみた
		//

		textView = new TextView(this);
		textView.setText("LinearLayout");
		linearLayout.addView(textView);

		createLayoutByLinearLayout(linearLayout);

		Log.d(TAG,
				"linearLayout.getOrientation()="
						+ linearLayout.getOrientation());
		Log.d(TAG,
				"linearLayout.getChildCount()=" + linearLayout.getChildCount());

		setContentView(linearLayout);
	}

	private void createLayoutByTableLayout(LinearLayout linearLayout) {
		TableLayout tableLayout = new TableLayout(this);

		for (int i = 0; i < 3; i++) {
			TableRow tableRow = new TableRow(this);

			for (int j = 0; j < 3; j++) {
				TextView textView = new TextView(this);
				textView.setText("●TextViewTextViewTextView " + i + "," + j);

				// 各TextViewのテキストが1行で表示され、画面からはみ出してしまった。
				// tableRow.addView(textView);

				// 何も表示されなくなった。
				// tableRow.addView(textView, new LinearLayout.LayoutParams(
				// LinearLayout.LayoutParams.WRAP_CONTENT,
				// LinearLayout.LayoutParams.WRAP_CONTENT, 1));

				// OK!
				// 参考ページ
				// しずくくんのAndroidでゲームプログラミングしてみたいなblog :
				// コードで動的にTableRowを作り、子のTextViewにsetLayoutParamsをする
				// http://blog.livedoor.jp/shizuku_kun/archives/51404514.html
				tableRow.addView(textView, new TableRow.LayoutParams(
						LinearLayout.LayoutParams.WRAP_CONTENT,
						LinearLayout.LayoutParams.WRAP_CONTENT, 1));

			}

			tableLayout.addView(tableRow);
		}

		linearLayout.addView(tableLayout);
	}

	private void createLayoutByLinearLayout(LinearLayout linearLayout) {
		for (int i = 0; i < 3; i++) {
			LinearLayout rowLinearLayout = new LinearLayout(this);
			rowLinearLayout.setOrientation(LinearLayout.HORIZONTAL);

			for (int j = 0; j < 3; j++) {
				TextView textView = new TextView(this);
				textView.setText("●TextViewTextViewTextView " + i + "," + j);

				// 画面からはみ出してしまった。
				// rowLinearLayout.addView(textView);

				// OK! 幅が等分されて表示された。
				rowLinearLayout.addView(textView,
						new LinearLayout.LayoutParams(
								LinearLayout.LayoutParams.WRAP_CONTENT,
								LinearLayout.LayoutParams.WRAP_CONTENT, 1));
			}

			linearLayout.addView(rowLinearLayout);
		}
	}

}
