package com.kurukurupapa.tryandroid.fw;

import android.graphics.PointF;

/**
 * Canvas#drawLines(float[] pts, Paint paint)の第一引数作成クラス
 */
public class Lines {
	private float[] data;
	private int index;

	public Lines(int numPoint) {
		// 0→0
		// 1→2
		// 2→4 = (2-1)*4
		// 3→8 = (3-1)*4
		// 4→12 = (4-1)*4
		int size = 0;
		if (numPoint <= 1) {
			size = numPoint * 2;
		} else {
			size = (numPoint - 1) * 4;
		}
		data = new float[size];
		index = 0;
	}

	public float[] getData() {
		return data;
	}

	public void add(PointF point) {
		add(point.x, point.y);
	}

	public void add(float x, float y) {
		// 注意：配列要素4つで1つのラインとなる

		if (index >= 4) {
			data[index] = data[index - 2];
			data[index + 1] = data[index - 1];
			index += 2;
		}

		data[index++] = x;
		data[index++] = y;
	}
}
