package com.kurukurupapa.tryandroiddb.top;

import com.kurukurupapa.tryandroiddb.top.model.Item;
import com.kurukurupapa.tryandroiddb.top.model.ItemList;
import com.kurukurupapa.tryandroiddb.top.model.ItemListFactory;

import android.app.ListActivity;
import android.os.Bundle;
import android.view.View;
import android.widget.ListView;

public class TryAndroidDbActivity extends ListActivity {

	private ItemList itemList;

	/** Called when the activity is first created. */
	@Override
	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);

		itemList = ItemListFactory.getItemList();
		setListAdapter(ItemListToListAdapter.getListAdapter(this,
				itemList));
	}

	@Override
	protected void onListItemClick(ListView l, View v, int position, long id) {
		super.onListItemClick(l, v, position, id);

		Item item = itemList.get(position);
		startActivity(ItemToIntent.getIntent(this, item));
	}


}