package com.kurukurupapa.tryandroiddb.performance;

import android.content.Context;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;

public class DbHelper extends SQLiteOpenHelper {
	private static final String NAME = "db";
	private static final int VERSION = 1;

	public DbHelper(Context context) {
		super(context, NAME, null, VERSION);
	}

	@Override
	public void onCreate(SQLiteDatabase db) {
		create(db);
	}

	@Override
	public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
		drop(db);
		create(db);
	}

	private void create(SQLiteDatabase db) {
		db.execSQL("create table performance_entity ("
				+ "id integer primary key autoincrement"
				+ ",text text not null" + ",timestamp integer not null" + ")");
	}

	private void drop(SQLiteDatabase db) {
		db.execSQL("drop table if exists performance_entity");
	}

	public void clear() {
		SQLiteDatabase db = getWritableDatabase();
		try {
			drop(db);
			create(db);
		} finally {
			db.close();
		}
	}
}
