package com.kurukurupapa.tryandroiddb.db002;

import java.text.DateFormat;
import java.text.SimpleDateFormat;

import com.kurukurupapa.tryandroid.fw.annotation.Exclude;
import com.kurukurupapa.tryandroid.fw.annotation.GeneratedValue;
import com.kurukurupapa.tryandroid.fw.util.LogUtil;

/**
 * サンプルテーブルクラス
 */
public class Record {
	@Exclude
	public static DateFormat dateFormat = new SimpleDateFormat(
			"yyyy/MM/dd hh:mm:ss");

	@GeneratedValue
	public int id;

	public String text;
	public long timestamp;

	public String getDateString() {
		String result = "Unknown";
		try {
			result = dateFormat.format(timestamp);
		} catch (Exception e) {
			LogUtil.e("timestamp=" + timestamp + ", ", e);
		}
		return result;
	}

	public String toString() {
		return "id=" + id + ",text=" + text + ",date=" + getDateString();
	}
}
