package com.kurukurupapa.tryandroiddb.db001;

import java.text.DateFormat;
import java.text.SimpleDateFormat;

import com.kurukurupapa.tryandroid.fw.util.LogUtil;

import android.content.ContentValues;

/**
 * サンプルテーブルクラス
 */
public class Record {
	public static DateFormat dateFormat = new SimpleDateFormat(
			"yyyy/MM/dd hh:mm:ss");

	public int id;
	public String text;
	public long timestamp;

	public String getDateString() {
		String result = "Unknown";
		try {
			result = dateFormat.format(timestamp);
		} catch (Exception e) {
			LogUtil.e("date=" + timestamp + ", ", e);
		}
		return result;
	}

	public void setTimestamp(long timestamp) {
		this.timestamp = timestamp;
	}

	public String toString() {
		StringBuffer sb = new StringBuffer();
		sb.append(String.valueOf(id));
		sb.append(", " + text);
		sb.append(", " + getDateString());
		return sb.toString();
	}

	public ContentValues getNoIdContentValues() {
		ContentValues values = new ContentValues();
		values.put("text", text);
		values.put("timestamp", timestamp);
		return values;
	}

	public ContentValues getFullContentValues() {
		ContentValues values = getNoIdContentValues();
		values.put("id", id);
		return values;
	}
}
