package com.tryandroid.etc;

import java.util.List;

import org.apache.commons.lang.builder.ToStringBuilder;

import com.kurukurupapa.tryandroid.fw.util.LogUtil;

import android.R;
import android.app.ActivityManager.RunningAppProcessInfo;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.pm.PackageManager.NameNotFoundException;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.TextView;

public class RunningAppProcessInfoListAdapter extends
		ArrayAdapter<RunningAppProcessInfo> {
	private LayoutInflater layoutInflater = null;
	private PackageManager pm;

	private class ViewHolder {
		public TextView text1;
		public TextView text2;
	}

	public RunningAppProcessInfoListAdapter(Context context,
			List<RunningAppProcessInfo> list) {
		super(context, 0, list);
		this.layoutInflater = LayoutInflater.from(context);
		pm = context.getPackageManager();
	}

	@Override
	public View getView(int position, View convertView, ViewGroup parent) {
		LogUtil.called();

		// データ取得
		RunningAppProcessInfo processInfo = getItem(position);

		// View取得
		ViewHolder viewHolder;
		if (convertView == null) {
			// View生成
			convertView = layoutInflater.inflate(R.layout.simple_list_item_2,
					null);
			viewHolder = new ViewHolder();
			viewHolder.text1 = (TextView) convertView.findViewById(R.id.text1);
			viewHolder.text2 = (TextView) convertView.findViewById(R.id.text2);
			convertView.setTag(viewHolder);
		} else {
			// Viewを使い回す
			viewHolder = (ViewHolder) convertView.getTag();
		}

		// 文字列組み立て
		StringBuilder sb = new StringBuilder();

		// フォアグラウンド/バックグラウンドなど取得
		sb.append("importance=" + processInfo.importance);
		switch (processInfo.importance) {
		// フォアグラウンドプロセス
		case RunningAppProcessInfo.IMPORTANCE_FOREGROUND:
			sb.append("(FOREGROUND)");
			break;
		// 可視プロセス
		case RunningAppProcessInfo.IMPORTANCE_VISIBLE:
			sb.append("(VISIBLE)");
			break;
		// サービスプロセス
		case RunningAppProcessInfo.IMPORTANCE_BACKGROUND:
			sb.append("(BACKGROUND)");
			break;
		// バックグラウンドプロセス
		case RunningAppProcessInfo.IMPORTANCE_SERVICE:
			sb.append("(SERVICE)");
			break;
		// 空のプロセス
		case RunningAppProcessInfo.IMPORTANCE_EMPTY:
			sb.append("(EMPTY)");
			break;
		}
		sb.append("\n");
		sb.append("processInfo="
				+ ToStringBuilder.reflectionToString(processInfo) + "\n");

		// アプリ情報取得
		try {
			ApplicationInfo appInfo = pm.getApplicationInfo(
					processInfo.processName, 0);
			// sb.append("ApplicationLabel=" + pm.getApplicationLabel(appInfo)
			// + "\n");
			// sb.append("appInfo.className=" + appInfo.className + "\n");
			// sb.append("appInfo.name=" + appInfo.name + "\n");
			// sb.append("appInfo.packageName=" + appInfo.packageName + "\n");
			// sb.append("appInfo.processName=" + appInfo.processName + "\n");
			// sb.append("appInfo.loadLabel()=" + appInfo.loadLabel(pm) + "\n");
			// sb.append("appInfo.loadDescription()="
			// + appInfo.loadDescription(pm) + "\n");
			sb.append("appInfo=" + ToStringBuilder.reflectionToString(appInfo)
					+ "\n");

		} catch (NameNotFoundException e) {
			sb.append("アプリ情報取得失敗\n");
		}

		sb.append("getLaunchIntentForPackage()="
				+ pm.getLaunchIntentForPackage(processInfo.processName) + "\n");

		// 値を設定
		viewHolder.text1.setText(processInfo.processName);
		viewHolder.text2.setText(sb.toString());

		return convertView;
	}
}
