/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.util.exception;

import org.seasar.util.collection.ArrayUtil;
import org.seasar.util.exception.SRuntimeException;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class SAXRuntimeException
extends SRuntimeException {
    private static final long serialVersionUID = -4933312103385038765L;

    public SAXRuntimeException(SAXException cause) {
        super("EUTL0054", ArrayUtil.asArray(SAXRuntimeException.createMessage(cause)), cause);
    }

    protected static String createMessage(SAXException cause) {
        StringBuilder buf = new StringBuilder(100);
        buf.append(cause);
        if (cause instanceof SAXParseException) {
            SAXParseException e = (SAXParseException)cause;
            if (e.getSystemId() != null) {
                buf.append(" at ").append(e.getSystemId());
            }
            int lineNumber = e.getLineNumber();
            int columnNumber = e.getColumnNumber();
            buf.append("( lineNumber = ").append(lineNumber).append(", columnNumber = ").append(columnNumber).append(")");
        }
        return new String(buf);
    }
}

