/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cordova;

import android.net.Proxy;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.LinkedList;
import java.util.UUID;

public class CallbackServer
implements Runnable {
    private static final String LOG_TAG = "CallbackServer";
    private LinkedList<String> javascript = new LinkedList();
    private int port = 0;
    private Thread serverThread;
    private boolean active = false;
    private boolean empty = true;
    private boolean usePolling = true;
    private String token;
    static final String digits = "0123456789ABCDEF";

    public void init(String url) {
        this.active = false;
        this.empty = true;
        this.port = 0;
        this.javascript = new LinkedList();
        if (url != null && !url.startsWith("file://")) {
            this.usePolling = true;
            this.stopServer();
        } else if (Proxy.getDefaultHost() != null) {
            this.usePolling = true;
            this.stopServer();
        } else {
            this.usePolling = false;
            this.startServer();
        }
    }

    public void reinit(String url) {
        this.stopServer();
        this.init(url);
    }

    public boolean usePolling() {
        return this.usePolling;
    }

    public int getPort() {
        return this.port;
    }

    public String getToken() {
        return this.token;
    }

    public void startServer() {
        this.active = false;
        this.serverThread = new Thread(this);
        this.serverThread.start();
    }

    public void restartServer() {
        this.stopServer();
        this.startServer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            this.active = true;
            ServerSocket waitSocket = new ServerSocket(0);
            this.port = waitSocket.getLocalPort();
            this.token = UUID.randomUUID().toString();
            while (this.active) {
                Socket connection = waitSocket.accept();
                BufferedReader xhrReader = new BufferedReader(new InputStreamReader(connection.getInputStream()), 40);
                DataOutputStream output = new DataOutputStream(connection.getOutputStream());
                String request = xhrReader.readLine();
                String response = "";
                if (this.active && request != null) {
                    if (request.contains("GET")) {
                        String[] requestParts = request.split(" ");
                        if (requestParts.length == 3 && requestParts[1].substring(1).equals(this.token)) {
                            CallbackServer callbackServer = this;
                            synchronized (callbackServer) {
                                while (this.empty) {
                                    try {
                                        this.wait(10000L);
                                        break;
                                    }
                                    catch (Exception e) {
                                    }
                                }
                            }
                            if (this.active) {
                                if (this.empty) {
                                    response = "HTTP/1.1 404 NO DATA\r\n\r\n ";
                                } else {
                                    response = "HTTP/1.1 200 OK\r\n\r\n";
                                    String js = this.getJavascript();
                                    if (js != null) {
                                        response = response + CallbackServer.encode(js, "UTF-8");
                                    }
                                }
                            } else {
                                response = "HTTP/1.1 503 Service Unavailable\r\n\r\n ";
                            }
                        } else {
                            response = "HTTP/1.1 403 Forbidden\r\n\r\n ";
                        }
                    } else {
                        response = "HTTP/1.1 400 Bad Request\r\n\r\n ";
                    }
                    output.writeBytes(response);
                    output.flush();
                }
                output.close();
                xhrReader.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.active = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopServer() {
        if (this.active) {
            this.active = false;
            CallbackServer callbackServer = this;
            synchronized (callbackServer) {
                this.notify();
            }
        }
    }

    public void destroy() {
        this.stopServer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSize() {
        CallbackServer callbackServer = this;
        synchronized (callbackServer) {
            int size = this.javascript.size();
            return size;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getJavascript() {
        CallbackServer callbackServer = this;
        synchronized (callbackServer) {
            if (this.javascript.size() == 0) {
                return null;
            }
            String statement = this.javascript.remove(0);
            if (this.javascript.size() == 0) {
                this.empty = true;
            }
            return statement;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendJavascript(String statement) {
        CallbackServer callbackServer = this;
        synchronized (callbackServer) {
            this.javascript.add(statement);
            this.empty = false;
            this.notify();
        }
    }

    public static String encode(String s, String enc) throws UnsupportedEncodingException {
        if (s == null || enc == null) {
            throw new NullPointerException();
        }
        "".getBytes(enc);
        StringBuilder buf = new StringBuilder(s.length() + 16);
        int start = -1;
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            if (ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z' || ch >= '0' && ch <= '9' || " .-*_'(),<>=?@[]{}:~\"\\/;!".indexOf(ch) > -1) {
                if (start >= 0) {
                    CallbackServer.convert(s.substring(start, i), buf, enc);
                    start = -1;
                }
                if (ch != ' ') {
                    buf.append(ch);
                    continue;
                }
                buf.append(' ');
                continue;
            }
            if (start >= 0) continue;
            start = i;
        }
        if (start >= 0) {
            CallbackServer.convert(s.substring(start, s.length()), buf, enc);
        }
        return buf.toString();
    }

    private static void convert(String s, StringBuilder buf, String enc) throws UnsupportedEncodingException {
        byte[] bytes = s.getBytes(enc);
        for (int j = 0; j < bytes.length; ++j) {
            buf.append('%');
            buf.append(digits.charAt((bytes[j] & 0xF0) >> 4));
            buf.append(digits.charAt(bytes[j] & 0xF));
        }
    }
}

