/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.util.xml;

import java.io.IOException;
import javax.xml.parsers.SAXParser;
import org.seasar.util.exception.IORuntimeException;
import org.seasar.util.exception.SAXRuntimeException;
import org.seasar.util.misc.AssertionUtil;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public abstract class SAXParserUtil {
    public static void parse(SAXParser parser, InputSource inputSource, DefaultHandler handler) {
        AssertionUtil.assertArgumentNotNull("parser", parser);
        AssertionUtil.assertArgumentNotNull("inputSource", inputSource);
        AssertionUtil.assertArgumentNotNull("handler", handler);
        try {
            parser.parse(inputSource, handler);
        }
        catch (SAXException e) {
            throw new SAXRuntimeException(e);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static void setProperty(SAXParser parser, String name, String value) {
        AssertionUtil.assertArgumentNotNull("parser", parser);
        AssertionUtil.assertArgumentNotEmpty("name", name);
        try {
            parser.setProperty(name, value);
        }
        catch (SAXException e) {
            throw new SAXRuntimeException(e);
        }
    }
}

