/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.util.net;

import java.io.IOException;
import java.io.InputStream;
import java.net.URLConnection;
import org.seasar.util.exception.IORuntimeException;
import org.seasar.util.io.CloseableUtil;
import org.seasar.util.io.ResourceUtil;
import org.seasar.util.misc.AssertionUtil;

public abstract class MimeTypeUtil {
    public static String guessContentType(String path) {
        AssertionUtil.assertArgumentNotEmpty("path", path);
        InputStream is = ResourceUtil.getResourceAsStream(path);
        try {
            String mimetype = URLConnection.guessContentTypeFromStream(is);
            if (mimetype != null) {
                String string = mimetype;
                return string;
            }
            String string = URLConnection.guessContentTypeFromName(path);
            return string;
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        finally {
            CloseableUtil.close(is);
        }
    }
}

