/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.util.misc;

import java.util.Collection;
import java.util.Map;
import org.seasar.util.collection.ArrayUtil;
import org.seasar.util.exception.EmptyArgumentException;
import org.seasar.util.exception.NullArgumentException;
import org.seasar.util.exception.SIllegalArgumentException;
import org.seasar.util.exception.SIllegalStateException;
import org.seasar.util.exception.SIndexOutOfBoundsException;
import org.seasar.util.lang.StringUtil;

public abstract class AssertionUtil {
    public static void assertArgumentNotNull(String argName, Object argValue) {
        if (argValue == null) {
            throw new NullArgumentException(argName);
        }
    }

    public static void assertArgumentNotEmpty(String argName, String argValue) {
        if (StringUtil.isEmpty(argValue)) {
            throw new EmptyArgumentException(argName, "EUTL0010", ArrayUtil.asArray(argName));
        }
    }

    public static void assertArgumentNotEmpty(String argName, CharSequence argValue) {
        if (argValue == null || argValue.length() == 0) {
            throw new EmptyArgumentException(argName, "EUTL0010", ArrayUtil.asArray(argName));
        }
    }

    public static void assertArgumentNotEmpty(String argName, Object[] argValue) {
        if (ArrayUtil.isEmpty(argValue)) {
            throw new EmptyArgumentException(argName, "EUTL0011", ArrayUtil.asArray(argName));
        }
    }

    public static void assertArgumentNotEmpty(String argName, boolean[] argValue) {
        if (ArrayUtil.isEmpty(argValue)) {
            throw new EmptyArgumentException(argName, "EUTL0011", ArrayUtil.asArray(argName));
        }
    }

    public static void assertArgumentNotEmpty(String argName, byte[] argValue) {
        if (ArrayUtil.isEmpty(argValue)) {
            throw new EmptyArgumentException(argName, "EUTL0011", ArrayUtil.asArray(argName));
        }
    }

    public static void assertArgumentNotEmpty(String argName, short[] argValue) {
        if (ArrayUtil.isEmpty(argValue)) {
            throw new EmptyArgumentException(argName, "EUTL0011", ArrayUtil.asArray(argName));
        }
    }

    public static void assertArgumentNotEmpty(String argName, int[] argValue) {
        if (ArrayUtil.isEmpty(argValue)) {
            throw new EmptyArgumentException(argName, "EUTL0011", ArrayUtil.asArray(argName));
        }
    }

    public static void assertArgumentNotEmpty(String argName, long[] argValue) {
        if (ArrayUtil.isEmpty(argValue)) {
            throw new EmptyArgumentException(argName, "EUTL0011", ArrayUtil.asArray(argName));
        }
    }

    public static void assertArgumentNotEmpty(String argName, float[] argValue) {
        if (ArrayUtil.isEmpty(argValue)) {
            throw new EmptyArgumentException(argName, "EUTL0011", ArrayUtil.asArray(argName));
        }
    }

    public static void assertArgumentNotEmpty(String argName, double[] argValue) {
        if (ArrayUtil.isEmpty(argValue)) {
            throw new EmptyArgumentException(argName, "EUTL0011", ArrayUtil.asArray(argName));
        }
    }

    public static void assertArgumentNotEmpty(String argName, char[] argValue) {
        if (ArrayUtil.isEmpty(argValue)) {
            throw new EmptyArgumentException(argName, "EUTL0011", ArrayUtil.asArray(argName));
        }
    }

    public static void assertArgumentNotEmpty(String argName, Collection<?> argValue) {
        if (argValue == null || argValue.isEmpty()) {
            throw new EmptyArgumentException(argName, "EUTL0012", ArrayUtil.asArray(argName));
        }
    }

    public static void assertArgumentNotEmpty(String argName, Map<?, ?> argValue) {
        if (argValue == null || argValue.isEmpty()) {
            throw new EmptyArgumentException(argName, "EUTL0013", ArrayUtil.asArray(argName));
        }
    }

    public static void assertArgumentArrayIndex(String argName, int argValue, int arraySize) {
        if (argValue < 0) {
            throw new SIllegalArgumentException(argName, "EUTL0014", ArrayUtil.asArray(argName));
        }
        if (argValue >= arraySize) {
            throw new SIllegalArgumentException(argName, "EUTL0015", ArrayUtil.asArray(argName, arraySize));
        }
    }

    public static void assertArgument(String argName, boolean expression, String description) {
        if (!expression) {
            throw new SIllegalArgumentException(argName, "EUTL0009", ArrayUtil.asArray(argName, description));
        }
    }

    public static void assertState(boolean expression, String description) {
        if (!expression) {
            throw new SIllegalStateException(description);
        }
    }

    public static void assertIndex(boolean expression, String description) {
        if (!expression) {
            throw new SIndexOutOfBoundsException(description);
        }
    }
}

