/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.util.lang;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import org.seasar.util.exception.IllegalAccessRuntimeException;
import org.seasar.util.exception.InvocationTargetRuntimeException;
import org.seasar.util.lang.GenericsUtil;
import org.seasar.util.misc.AssertionUtil;

public abstract class MethodUtil {
    public static <T> T invoke(Method method, Object target, Object ... args) throws InvocationTargetRuntimeException, IllegalAccessRuntimeException {
        AssertionUtil.assertArgumentNotNull("method", method);
        try {
            return (T)method.invoke(target, args);
        }
        catch (InvocationTargetException ex) {
            Throwable t = ex.getCause();
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
            throw new InvocationTargetRuntimeException(method.getDeclaringClass(), ex);
        }
        catch (IllegalAccessException ex) {
            throw new IllegalAccessRuntimeException(method.getDeclaringClass(), ex);
        }
    }

    public static <T> T invokeStatic(Method method, Object ... args) throws InvocationTargetRuntimeException, IllegalAccessRuntimeException {
        AssertionUtil.assertArgumentNotNull("method", method);
        return MethodUtil.invoke(method, null, args);
    }

    public static boolean isAbstract(Method method) {
        return Modifier.isAbstract(method.getModifiers());
    }

    public static boolean isPublic(Method method) {
        AssertionUtil.assertArgumentNotNull("method", method);
        return Modifier.isPublic(method.getModifiers());
    }

    public static boolean isStatic(Method method) {
        AssertionUtil.assertArgumentNotNull("method", method);
        return Modifier.isStatic(method.getModifiers());
    }

    public static boolean isFinal(Method method) {
        AssertionUtil.assertArgumentNotNull("method", method);
        return Modifier.isFinal(method.getModifiers());
    }

    public static String getSignature(String methodName, Class<?> ... argTypes) {
        AssertionUtil.assertArgumentNotEmpty("methodName", methodName);
        StringBuilder buf = new StringBuilder(100);
        buf.append(methodName).append("(");
        if (argTypes != null && argTypes.length > 0) {
            for (Class<?> argType : argTypes) {
                buf.append(argType.getName()).append(", ");
            }
            buf.setLength(buf.length() - 2);
        }
        buf.append(")");
        return new String(buf);
    }

    public static String getSignature(String methodName, Object ... methodArgs) {
        AssertionUtil.assertArgumentNotEmpty("methodName", methodName);
        StringBuilder buf = new StringBuilder(100);
        buf.append(methodName).append("(");
        if (methodArgs != null && methodArgs.length > 0) {
            for (Object arg : methodArgs) {
                buf.append(arg == null ? null : arg.getClass().getName()).append(", ");
            }
            buf.setLength(buf.length() - 2);
        }
        buf.append(")");
        return buf.toString();
    }

    public static boolean isEqualsMethod(Method method) {
        AssertionUtil.assertArgumentNotNull("method", method);
        return method != null && method.getName().equals("equals") && method.getReturnType() == Boolean.TYPE && method.getParameterTypes().length == 1 && method.getParameterTypes()[0] == Object.class;
    }

    public static boolean isHashCodeMethod(Method method) {
        AssertionUtil.assertArgumentNotNull("method", method);
        return method != null && method.getName().equals("hashCode") && method.getReturnType() == Integer.TYPE && method.getParameterTypes().length == 0;
    }

    public static boolean isToStringMethod(Method method) {
        AssertionUtil.assertArgumentNotNull("method", method);
        return method != null && method.getName().equals("toString") && method.getReturnType() == String.class && method.getParameterTypes().length == 0;
    }

    public static Class<?> getElementTypeOfCollectionFromParameterType(Method method, int position) {
        AssertionUtil.assertArgumentNotNull("method", method);
        Type[] parameterTypes = method.getGenericParameterTypes();
        return GenericsUtil.getRawClass(GenericsUtil.getElementTypeOfCollection(parameterTypes[position]));
    }

    public static Class<?> getElementTypeOfCollectionFromReturnType(Method method) {
        AssertionUtil.assertArgumentNotNull("method", method);
        Type returnType = method.getGenericReturnType();
        return GenericsUtil.getRawClass(GenericsUtil.getElementTypeOfCollection(returnType));
    }

    public static Class<?> getKeyTypeOfMapFromParameterType(Method method, int position) {
        AssertionUtil.assertArgumentNotNull("method", method);
        Type[] parameterTypes = method.getGenericParameterTypes();
        return GenericsUtil.getRawClass(GenericsUtil.getKeyTypeOfMap(parameterTypes[position]));
    }

    public static Class<?> getKeyTypeOfMapFromReturnType(Method method) {
        AssertionUtil.assertArgumentNotNull("method", method);
        Type returnType = method.getGenericReturnType();
        return GenericsUtil.getRawClass(GenericsUtil.getKeyTypeOfMap(returnType));
    }

    public static Class<?> getValueTypeOfMapFromParameterType(Method method, int position) {
        AssertionUtil.assertArgumentNotNull("method", method);
        Type[] parameterTypes = method.getGenericParameterTypes();
        return GenericsUtil.getRawClass(GenericsUtil.getValueTypeOfMap(parameterTypes[position]));
    }

    public static Class<?> getValueTypeOfMapFromReturnType(Method method) {
        AssertionUtil.assertArgumentNotNull("method", method);
        Type returnType = method.getGenericReturnType();
        return GenericsUtil.getRawClass(GenericsUtil.getValueTypeOfMap(returnType));
    }
}

