/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.util.crypto;

import java.io.UnsupportedEncodingException;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import javax.crypto.Cipher;
import org.seasar.util.collection.CollectionsUtil;
import org.seasar.util.crypto.CipherContext;
import org.seasar.util.exception.SIllegalStateException;
import org.seasar.util.misc.AssertionUtil;
import org.seasar.util.misc.Base64Util;

public abstract class CipherPoolUtil {
    protected static final ConcurrentMap<String, Queue<Cipher>> encryptoQueueMap = CollectionsUtil.newConcurrentHashMap();
    protected static final ConcurrentMap<String, Queue<Cipher>> decryptoQueueMap = CollectionsUtil.newConcurrentHashMap();

    public static void create(CipherContext context, int size) {
        AssertionUtil.assertArgumentNotNull("context", context);
        Queue<Cipher> encryptoCipherQueue = CipherPoolUtil.getEncryptoCipherQueue(context);
        Queue<Cipher> decryptoCipherQueue = CipherPoolUtil.getDecryptoCipherQueue(context);
        for (int i = 0; i < size; ++i) {
            encryptoCipherQueue.add(context.getCipher(1));
            decryptoCipherQueue.add(context.getCipher(2));
        }
    }

    public static byte[] encrypto(CipherContext context, byte[] data) {
        AssertionUtil.assertArgumentNotNull("context", context);
        AssertionUtil.assertArgumentNotNull("data", data);
        Cipher cipher = CipherPoolUtil.getEncryptoCipher(context);
        try {
            byte[] encrypted = cipher.doFinal(data);
            CipherPoolUtil.putEncryptoCipher(context, cipher);
            return encrypted;
        }
        catch (Exception e) {
            throw new SIllegalStateException(e);
        }
    }

    public static String encryptoText(CipherContext context, String text, String charsetName) {
        AssertionUtil.assertArgumentNotNull("context", context);
        AssertionUtil.assertArgumentNotNull("text", text);
        AssertionUtil.assertArgumentNotEmpty("charsetName", charsetName);
        try {
            return Base64Util.encode(CipherPoolUtil.encrypto(context, text.getBytes(charsetName)));
        }
        catch (Exception e) {
            throw new SIllegalStateException(e);
        }
    }

    public static byte[] decrypto(CipherContext context, byte[] data) {
        AssertionUtil.assertArgumentNotNull("context", context);
        AssertionUtil.assertArgumentNotNull("data", data);
        Cipher cipher = CipherPoolUtil.getDecryptoCipher(context);
        try {
            byte[] decrypted = cipher.doFinal(data);
            CipherPoolUtil.putDecryptoCipher(context, cipher);
            return decrypted;
        }
        catch (Exception e) {
            throw new SIllegalStateException(e);
        }
    }

    public static String decryptoText(CipherContext context, String text, String charsetName) {
        AssertionUtil.assertArgumentNotNull("context", context);
        AssertionUtil.assertArgumentNotNull("text", text);
        AssertionUtil.assertArgumentNotEmpty("charsetName", charsetName);
        try {
            return new String(CipherPoolUtil.decrypto(context, Base64Util.decode(text)), charsetName);
        }
        catch (UnsupportedEncodingException e) {
            throw new SIllegalStateException(e);
        }
    }

    private static Cipher getEncryptoCipher(CipherContext context) {
        Cipher cipher = CipherPoolUtil.getEncryptoCipherQueue(context).poll();
        if (cipher == null) {
            return context.getCipher(1);
        }
        return cipher;
    }

    private static void putEncryptoCipher(CipherContext context, Cipher cipher) {
        CipherPoolUtil.getEncryptoCipherQueue(context).offer(cipher);
    }

    private static Queue<Cipher> getEncryptoCipherQueue(CipherContext context) {
        Queue queue = (Queue)encryptoQueueMap.get(context.getId());
        if (queue != null) {
            return queue;
        }
        return CollectionsUtil.putIfAbsent(encryptoQueueMap, context.getId(), new ConcurrentLinkedQueue());
    }

    private static Cipher getDecryptoCipher(CipherContext context) {
        Cipher cipher = CipherPoolUtil.getDecryptoCipherQueue(context).poll();
        if (cipher == null) {
            return context.getCipher(2);
        }
        return cipher;
    }

    private static void putDecryptoCipher(CipherContext context, Cipher cipher) {
        CipherPoolUtil.getDecryptoCipherQueue(context).offer(cipher);
    }

    private static Queue<Cipher> getDecryptoCipherQueue(CipherContext context) {
        Queue queue = (Queue)decryptoQueueMap.get(context.getId());
        if (queue != null) {
            return queue;
        }
        return CollectionsUtil.putIfAbsent(decryptoQueueMap, context.getId(), new ConcurrentLinkedQueue());
    }
}

