/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.util.beans.converter;

import java.util.Date;
import org.seasar.util.beans.Converter;
import org.seasar.util.convert.DateConversionUtil;
import org.seasar.util.convert.StringConversionUtil;
import org.seasar.util.lang.StringUtil;
import org.seasar.util.misc.AssertionUtil;

public class DateConverter
implements Converter {
    protected String pattern;

    public DateConverter(String pattern) {
        AssertionUtil.assertArgumentNotEmpty("pattern", pattern);
        this.pattern = pattern;
    }

    @Override
    public Object getAsObject(String value) {
        if (StringUtil.isEmpty(value)) {
            return null;
        }
        return DateConversionUtil.toDate((Object)value, this.pattern);
    }

    @Override
    public String getAsString(Object value) {
        if (value == null) {
            return null;
        }
        return StringConversionUtil.toString((Date)value, this.pattern);
    }

    @Override
    public boolean isTarget(Class<?> clazz) {
        AssertionUtil.assertArgumentNotNull("clazz", clazz);
        return clazz == Date.class;
    }
}

