package jp.kirikiri.tvp2.visual;

import jp.kirikiri.tjs2.Dispatch2;
import jp.kirikiri.tjs2.NativeClass;
import jp.kirikiri.tjs2.NativeClassConstructor;
import jp.kirikiri.tjs2.NativeClassMethod;
import jp.kirikiri.tjs2.NativeClassProperty;
import jp.kirikiri.tjs2.NativeInstance;
import jp.kirikiri.tjs2.TJS;
import jp.kirikiri.tjs2.TJSException;
import jp.kirikiri.tjs2.Variant;
import jp.kirikiri.tjs2.VariantException;

public class PassThroughDrawDeviceClass extends NativeClass {

	static private int mClassID = -1;
	static private final String CLASS_NAME = "PassThroughDrawDevice";

	static private final int
		E_NOTIMPL		= -1002,
		E_BADPARAMCOUNT	= -1004,
		E_ACCESSDENYED	= -1007,
		E_NATIVECLASSCRASH = -1008,
		S_OK			= 0;

	static private final int // enum tTJSNativeInstanceType
		nitMethod	= 1,
		nitProperty = 2;

	protected NativeInstance createNativeInstance() {
		return null;
	}

	public PassThroughDrawDeviceClass() throws VariantException, TJSException {
		super(CLASS_NAME);
		final int NCM_CLASSID = TJS.registerNativeClass(CLASS_NAME);
		setClassID( NCM_CLASSID );
		mClassID = NCM_CLASSID;

		// constructor
		registerNCM( CLASS_NAME, new NativeClassConstructor() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) {
				return S_OK;
			}
		}, CLASS_NAME, nitMethod, 0 );

		registerNCM( "finalize", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) {
				return S_OK;
			}
		}, CLASS_NAME, nitMethod, 0 );

		registerNCM( "recreate", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws TJSException {
				return E_NOTIMPL;
			}
		}, CLASS_NAME, nitMethod, 0 );


		registerNCM( "interface", new NativeClassProperty() {
			@Override public int get(Variant result, Dispatch2 objthis) { return E_ACCESSDENYED; }
			@Override public int set(Variant param, Dispatch2 objthis) { return E_ACCESSDENYED; }
		}, CLASS_NAME, nitProperty, 0 );

		registerNCM( "dtNone", new NativeClassProperty() {
			@Override public int get(Variant result, Dispatch2 objthis) { result.set(0); return S_OK; }
			@Override public int set(Variant param, Dispatch2 objthis) { return E_ACCESSDENYED; }
		}, CLASS_NAME, nitProperty, 0 );
		registerNCM( "dtDrawDib", new NativeClassProperty() {
			@Override public int get(Variant result, Dispatch2 objthis) { result.set(1); return S_OK; }
			@Override public int set(Variant param, Dispatch2 objthis) { return E_ACCESSDENYED; }
		}, CLASS_NAME, nitProperty, 0 );
		registerNCM( "dtDBGDI", new NativeClassProperty() {
			@Override public int get(Variant result, Dispatch2 objthis) { result.set(2); return S_OK; }
			@Override public int set(Variant param, Dispatch2 objthis) { return E_ACCESSDENYED; }
		}, CLASS_NAME, nitProperty, 0 );
		registerNCM( "dtDBDD", new NativeClassProperty() {
			@Override public int get(Variant result, Dispatch2 objthis) { result.set(3); return S_OK; }
			@Override public int set(Variant param, Dispatch2 objthis) { return E_ACCESSDENYED; }
		}, CLASS_NAME, nitProperty, 0 );
		registerNCM( "dtDBD3D", new NativeClassProperty() {
			@Override public int get(Variant result, Dispatch2 objthis) { result.set(4); return S_OK; }
			@Override public int set(Variant param, Dispatch2 objthis) { return E_ACCESSDENYED; }
		}, CLASS_NAME, nitProperty, 0 );

		registerNCM( "preferredDrawer", new NativeClassProperty() {
			@Override public int get(Variant result, Dispatch2 objthis) { result.set(0); return S_OK; } // 常にdtNone値を返す
			@Override public int set(Variant param, Dispatch2 objthis) { return S_OK; } // 設定は無視する
		}, CLASS_NAME, nitProperty, 0 );

		registerNCM( "drawer", new NativeClassProperty() {
			@Override public int get(Variant result, Dispatch2 objthis) { result.set(0); return S_OK; } // 常にdtNone値を返す
			@Override public int set(Variant param, Dispatch2 objthis) { return E_ACCESSDENYED; }
		}, CLASS_NAME, nitProperty, 0 );
	}
}
