package jp.kirikiri.tvp2.visual;

import jp.kirikiri.tjs2.Dispatch2;
import jp.kirikiri.tjs2.Holder;
import jp.kirikiri.tjs2.NativeInstance;
import jp.kirikiri.tjs2.NativeInstanceObject;
import jp.kirikiri.tjs2.TJSException;
import jp.kirikiri.tjs2.Variant;
import jp.kirikiri.tjs2.VariantException;
import jp.kirikiri.tvp2.msg.Message;

public class FontNI extends NativeInstanceObject {

	static private final int
		E_BADPARAMCOUNT	= -1004,
		S_OK			= 0;

	static private final int NIS_GETINSTANCE = 0x00000002; // get native pointer

	private LayerNI mLayer;

	public int construct( Variant[] param, Dispatch2 tjs_obj ) throws TJSException {

		if( param.length < 1) return E_BADPARAMCOUNT;

		Dispatch2 dsp = param[0].asObject();

		Holder<NativeInstance> holder = new Holder<NativeInstance>(null);
		int hr = dsp.nativeInstanceSupport( NIS_GETINSTANCE, LayerClass.ClassID, holder );
		if( hr < 0 )
			Message.throwExceptionMessage(Message.SpecifyLayer);
		mLayer = (LayerNI) holder.mValue;
		return S_OK;
	}
	public void invalidate() throws VariantException, TJSException {
		mLayer = null;
		super.invalidate();
	}

	LayerNI getLayer() { return mLayer; }
}
