package jp.kirikiri.tvp2.visual;

import java.util.ArrayList;

import jp.kirikiri.tjs2.Dispatch2;
import jp.kirikiri.tjs2.Holder;
import jp.kirikiri.tjs2.Logger;
import jp.kirikiri.tjs2.NativeClass;
import jp.kirikiri.tjs2.NativeClassConstructor;
import jp.kirikiri.tjs2.NativeClassMethod;
import jp.kirikiri.tjs2.NativeClassProperty;
import jp.kirikiri.tjs2.NativeInstance;
import jp.kirikiri.tjs2.TJS;
import jp.kirikiri.tjs2.TJSException;
import jp.kirikiri.tjs2.Variant;
import jp.kirikiri.tjs2.VariantException;

public class FontClass extends NativeClass {

	static private int mClassID = -1;
	static private final int MEMBERENSURE = 0x00000200;

	static private final int
		E_MEMBERNOTFOUND = -1001,
		E_NOTIMPL		= -1002,
		E_BADPARAMCOUNT	= -1004,
		E_INVALIDOBJECT	= -1006,
		E_ACCESSDENYED	= -1007,
		E_NATIVECLASSCRASH = -1008,
		S_OK			= 0,
		S_TRUE			= 1;
	static private final int
		NIS_GETINSTANCE		= 0x00000002; // get native pointer
	static private final int // enum tTJSNativeInstanceType
		nitMethod	= 1,
		nitProperty = 2;

	static final private int STATICMEMBER	= 0x00010000;

	static private final String CLASS_NAME = "Font";

	protected NativeInstance createNativeInstance() {
		return new FontNI();
	}

	/*
	private static FontNI getNativeInstance( Dispatch2 objthis ) {
		Holder<NativeInstance> holder = new Holder<NativeInstance>(null);
		int hr = objthis.nativeInstanceSupport( NIS_GETINSTANCE, mClassID, holder );
		if( hr < 0 ) return null;
		return (FontNI) holder.mValue;
	}
	*/

	public FontClass() throws VariantException, TJSException {
		super( CLASS_NAME );
		final int NCM_CLASSID = TJS.registerNativeClass(CLASS_NAME);
		setClassID( NCM_CLASSID );
		mClassID = NCM_CLASSID;

		// constructor
		registerNCM( CLASS_NAME, new NativeClassConstructor() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws TJSException {
				FontNI _this = (FontNI)objthis.getNativeInstance(mClassID);
				if( _this == null ) return E_NATIVECLASSCRASH;
				int hr = _this.construct(param, objthis);
				if( hr < 0 ) return hr;
				return S_OK;
			}
		}, CLASS_NAME, nitMethod, 0 );


		registerNCM( "finalize", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) {
				return S_OK;
			}
		}, CLASS_NAME, nitMethod, 0 );

		registerNCM( "getTextWidth", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws TJSException {
				FontNI _this = (FontNI)objthis.getNativeInstance(mClassID);
				if( _this == null ) return E_NATIVECLASSCRASH;
				if(param.length < 1) return E_BADPARAMCOUNT;
				if( result != null ) result.set( _this.getLayer().getTextWidth(param[0].asString()) );
				return S_OK;
			}
		}, CLASS_NAME, nitMethod, 0 );

		registerNCM( "getTextHeight", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws TJSException {
				FontNI _this = (FontNI)objthis.getNativeInstance(mClassID);
				if( _this == null ) return E_NATIVECLASSCRASH;
				if(param.length < 1) return E_BADPARAMCOUNT;
				if( result != null ) result.set( _this.getLayer().getTextHeight(param[0].asString()) );
				return S_OK;
			}
		}, CLASS_NAME, nitMethod, 0 );

		registerNCM( "getEscWidthX", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws TJSException {
				FontNI _this = (FontNI)objthis.getNativeInstance(mClassID);
				if( _this == null ) return E_NATIVECLASSCRASH;
				if(param.length < 1) return E_BADPARAMCOUNT;
				if( result != null ) result.set( _this.getLayer().getEscWidthX(param[0].asString()) );
				return S_OK;
			}
		}, CLASS_NAME, nitMethod, 0 );

		registerNCM( "getEscWidthY", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws TJSException {
				FontNI _this = (FontNI)objthis.getNativeInstance(mClassID);
				if( _this == null ) return E_NATIVECLASSCRASH;
				if(param.length < 1) return E_BADPARAMCOUNT;
				if( result != null ) result.set( _this.getLayer().getEscWidthY(param[0].asString()) );
				return S_OK;
			}
		}, CLASS_NAME, nitMethod, 0 );

		registerNCM( "getEscHeightX", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws TJSException {
				FontNI _this = (FontNI)objthis.getNativeInstance(mClassID);
				if( _this == null ) return E_NATIVECLASSCRASH;
				if(param.length < 1) return E_BADPARAMCOUNT;
				if( result != null ) result.set( _this.getLayer().getEscHeightX(param[0].asString()) );
				return S_OK;
			}
		}, CLASS_NAME, nitMethod, 0 );

		registerNCM( "getEscHeightY", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws TJSException {
				FontNI _this = (FontNI)objthis.getNativeInstance(mClassID);
				if( _this == null ) return E_NATIVECLASSCRASH;
				if(param.length < 1) return E_BADPARAMCOUNT;
				if( result != null ) result.set( _this.getLayer().getEscHeightY(param[0].asString()) );
				return S_OK;
			}
		}, CLASS_NAME, nitMethod, 0 );

		registerNCM( "doUserSelect", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws VariantException {
				FontNI _this = (FontNI)objthis.getNativeInstance(mClassID);
				if( _this == null ) return E_NATIVECLASSCRASH;
				if(param.length < 4) return E_BADPARAMCOUNT;
				int flags = param[0].asInteger();
				String caption = param[1].asString();
				String prompt = param[2].asString();
				String samplestring = param[3].asString();
				int ret = _this.getLayer().doUserFontSelect( flags, caption, prompt, samplestring ) ? 1 : 0;
				if( result != null ) result.set( ret );
				return S_OK;
			}
		}, CLASS_NAME, nitMethod, 0 );

		registerNCM( "getList", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws TJSException {
				FontNI _this = (FontNI)objthis.getNativeInstance(mClassID);
				if( _this == null ) return E_NATIVECLASSCRASH;
				if(param.length < 1) return E_BADPARAMCOUNT;
				int flags = param[0].asInteger();
				ArrayList<String> list = new ArrayList<String>();
				_this.getLayer().getFontList(flags,list);
				if( result != null ) {
					Dispatch2 dsp = TJS.createArrayObject();
					result.set( dsp, dsp );
					final int count = list.size();
					Variant tmp = new Variant();
					for( int i = 0; i < count; i++) {
						tmp.set( list.get(i) );
						dsp.propSetByNum( MEMBERENSURE, i, tmp, dsp );
					}
				}
				return S_OK;
			}
		}, CLASS_NAME, nitMethod, 0 );

		registerNCM( "mapPrerenderedFont", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws TJSException {
				FontNI _this = (FontNI)objthis.getNativeInstance(mClassID);
				if( _this == null ) return E_NATIVECLASSCRASH;
				if(param.length < 1) return E_BADPARAMCOUNT;
				_this.getLayer().mapPrerenderedFont(param[0].asString());
				return S_OK;
			}
		}, CLASS_NAME, nitMethod, 0 );

		registerNCM( "unmapPrerenderedFont", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws VariantException {
				FontNI _this = (FontNI)objthis.getNativeInstance(mClassID);
				if( _this == null ) return E_NATIVECLASSCRASH;
				_this.getLayer().unmapPrerenderedFont();
				return S_OK;
			}
		}, CLASS_NAME, nitMethod, 0 );




		registerNCM( "face", new NativeClassProperty() {
			@Override public int get(Variant result, Dispatch2 objthis) {
				FontNI _this = (FontNI)objthis.getNativeInstance(mClassID);
				result.set( _this.getLayer().getFontFace() );
				return S_OK;
			}
			@Override public int set(Variant param, Dispatch2 objthis) throws VariantException {
				FontNI _this = (FontNI)objthis.getNativeInstance(mClassID);
				_this.getLayer().setFontFace(param.asString());
				return S_OK;
			}
		}, CLASS_NAME, nitProperty, 0 );

		registerNCM( "height", new NativeClassProperty() {
			@Override public int get(Variant result, Dispatch2 objthis) {
				FontNI _this = (FontNI)objthis.getNativeInstance(mClassID);
				result.set( _this.getLayer().getFontHeight() );
				return S_OK;
			}
			@Override public int set(Variant param, Dispatch2 objthis) throws VariantException {
				FontNI _this = (FontNI)objthis.getNativeInstance(mClassID);
				_this.getLayer().setFontHeight(param.asInteger());
				return S_OK;
			}
		}, CLASS_NAME, nitProperty, 0 );

		registerNCM( "bold", new NativeClassProperty() {
			@Override public int get(Variant result, Dispatch2 objthis) {
				FontNI _this = (FontNI)objthis.getNativeInstance(mClassID);
				result.set( _this.getLayer().getFontBold() ? 1 : 0 );
				return S_OK;
			}
			@Override public int set(Variant param, Dispatch2 objthis) {
				FontNI _this = (FontNI)objthis.getNativeInstance(mClassID);
				_this.getLayer().setFontBold(param.asBoolean());
				return S_OK;
			}
		}, CLASS_NAME, nitProperty, 0 );

		registerNCM( "italic", new NativeClassProperty() {
			@Override public int get(Variant result, Dispatch2 objthis) {
				FontNI _this = (FontNI)objthis.getNativeInstance(mClassID);
				result.set( _this.getLayer().getFontItalic() ? 1 : 0 );
				return S_OK;
			}
			@Override public int set(Variant param, Dispatch2 objthis) {
				FontNI _this = (FontNI)objthis.getNativeInstance(mClassID);
				_this.getLayer().setFontItalic(param.asBoolean());
				return S_OK;
			}
		}, CLASS_NAME, nitProperty, 0 );

		registerNCM( "strikeout", new NativeClassProperty() {
			@Override public int get(Variant result, Dispatch2 objthis) {
				FontNI _this = (FontNI)objthis.getNativeInstance(mClassID);
				result.set( _this.getLayer().getFontStrikeout() ? 1 : 0 );
				return S_OK;
			}
			@Override public int set(Variant param, Dispatch2 objthis) {
				FontNI _this = (FontNI)objthis.getNativeInstance(mClassID);
				_this.getLayer().setFontStrikeout(param.asBoolean());
				return S_OK;
			}
		}, CLASS_NAME, nitProperty, 0 );

		registerNCM( "underline", new NativeClassProperty() {
			@Override public int get(Variant result, Dispatch2 objthis) {
				FontNI _this = (FontNI)objthis.getNativeInstance(mClassID);
				result.set( _this.getLayer().getFontUnderline() ? 1 : 0 );
				return S_OK;
			}
			@Override public int set(Variant param, Dispatch2 objthis) {
				FontNI _this = (FontNI)objthis.getNativeInstance(mClassID);
				_this.getLayer().setFontUnderline(param.asBoolean());
				return S_OK;
			}
		}, CLASS_NAME, nitProperty, 0 );

		registerNCM( "angle", new NativeClassProperty() {
			@Override public int get(Variant result, Dispatch2 objthis) {
				FontNI _this = (FontNI)objthis.getNativeInstance(mClassID);
				result.set( _this.getLayer().getFontAngle() );
				return S_OK;
			}
			@Override public int set(Variant param, Dispatch2 objthis) throws VariantException {
				FontNI _this = (FontNI)objthis.getNativeInstance(mClassID);
				_this.getLayer().setFontAngle(param.asInteger());
				return S_OK;
			}
		}, CLASS_NAME, nitProperty, 0 );
	}

}
