package jp.kirikiri.tvp2.utils;

import jp.kirikiri.tjs2.Dispatch2;
import jp.kirikiri.tjs2.Holder;
import jp.kirikiri.tjs2.NativeClass;
import jp.kirikiri.tjs2.NativeClassConstructor;
import jp.kirikiri.tjs2.NativeClassMethod;
import jp.kirikiri.tjs2.NativeClassProperty;
import jp.kirikiri.tjs2.NativeInstance;
import jp.kirikiri.tjs2.TJS;
import jp.kirikiri.tjs2.TJSException;
import jp.kirikiri.tjs2.Variant;
import jp.kirikiri.tjs2.VariantClosure;
import jp.kirikiri.tjs2.VariantException;
import jp.kirikiri.tvp2.msg.Message;

public class KAGParserClass extends NativeClass {

	static private int mClassID = -1;
	static private final int
		E_BADPARAMCOUNT	= -1004,
		E_ACCESSDENYED	= -1007,
		E_NATIVECLASSCRASH = -1008,
		S_OK			= 0;
	static private final int
		NIS_GETINSTANCE		= 0x00000002; // get native pointer
	static private final int // enum tTJSNativeInstanceType
		nitMethod	= 1,
		nitProperty = 2;

	static private final String CLASS_NAME = "KAGParser";

	protected NativeInstance createNativeInstance() throws VariantException, TJSException {
		return new KAGParserNI();
	}
	/*
	private static KAGParserNI getNativeInstance( Dispatch2 objthis ) {
		Holder<NativeInstance> holder = new Holder<NativeInstance>(null);
		int hr = objthis.nativeInstanceSupport( NIS_GETINSTANCE, mClassID, holder );
		if( hr < 0 ) return null;
		return (KAGParserNI) holder.mValue;
	}
	*/

	public KAGParserClass() throws VariantException, TJSException {
		super( CLASS_NAME );
		final int NCM_CLASSID = TJS.registerNativeClass(CLASS_NAME);
		setClassID( NCM_CLASSID );
		mClassID = NCM_CLASSID;

		// constructor
		registerNCM( CLASS_NAME, new NativeClassConstructor() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws VariantException, TJSException {
				KAGParserNI _this = (KAGParserNI)objthis.getNativeInstance(mClassID);
				if( _this == null ) return E_NATIVECLASSCRASH;
				int hr = _this.construct(param, objthis);
				if( hr < 0 ) return hr;
				return S_OK;
			}
		}, CLASS_NAME, nitMethod, 0 );


		registerNCM( "finalize", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) {
				return S_OK;
			}
		}, CLASS_NAME, nitMethod, 0 );

		registerNCM( "loadScenario", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws TJSException {
				KAGParserNI _this = (KAGParserNI)objthis.getNativeInstance(mClassID);
				if( _this == null ) return E_NATIVECLASSCRASH;
				if( param.length < 1 ) return E_BADPARAMCOUNT;
				_this.loadScenario(param[0].asString());
				return S_OK;
			}
		}, CLASS_NAME, nitMethod, 0 );

		registerNCM( "goToLabel", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws TJSException {
				KAGParserNI _this = (KAGParserNI)objthis.getNativeInstance(mClassID);
				if( _this == null ) return E_NATIVECLASSCRASH;
				if( param.length < 1 ) return E_BADPARAMCOUNT;
				_this.goToLabel(param[0].asString());
				return S_OK;
			}
		}, CLASS_NAME, nitMethod, 0 );

		registerNCM( "callLabel", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws TJSException {
				KAGParserNI _this = (KAGParserNI)objthis.getNativeInstance(mClassID);
				if( _this == null ) return E_NATIVECLASSCRASH;
				if( param.length < 1 ) return E_BADPARAMCOUNT;
				_this.callLabel(param[0].asString());
				return S_OK;
			}
		}, CLASS_NAME, nitMethod, 0 );

		registerNCM( "getNextTag", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws TJSException {
				KAGParserNI _this = (KAGParserNI)objthis.getNativeInstance(mClassID);
				if( _this == null ) return E_NATIVECLASSCRASH;
				Dispatch2 dsp = _this.getNextTag();
				if(dsp == null) {
					if(result!=null) result.clear(); // return void ( not null )
				} else {
					if(result!=null) result.set( dsp, dsp );
				}
				return S_OK;
			}
		}, CLASS_NAME, nitMethod, 0 );

		registerNCM( "assign", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws TJSException {
				KAGParserNI _this = (KAGParserNI)objthis.getNativeInstance(mClassID);
				if( _this == null ) return E_NATIVECLASSCRASH;
				if( param.length < 1 ) return E_BADPARAMCOUNT;
				VariantClosure clo = param[0].asObjectClosure();
				if( clo.mObject!=null ) {
					Holder<NativeInstance> holder = new Holder<NativeInstance>(null);
					int hr = clo.mObject.nativeInstanceSupport( NIS_GETINSTANCE, KAGParserClass.mClassID, holder );
					if( hr < 0 )
						Message.throwExceptionMessage(Message.KAGSpecifyKAGParser);
					KAGParserNI src = (KAGParserNI) holder.mValue;
					_this.assign( src );
				} else {
					Message.throwExceptionMessage(Message.KAGSpecifyKAGParser);
				}
				return S_OK;
			}
		}, CLASS_NAME, nitMethod, 0 );

		registerNCM( "clear", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws VariantException {
				KAGParserNI _this = (KAGParserNI)objthis.getNativeInstance(mClassID);
				if( _this == null ) return E_NATIVECLASSCRASH;
				_this.clear();
				return S_OK;
			}
		}, CLASS_NAME, nitMethod, 0 );

		registerNCM( "store", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws TJSException {
				KAGParserNI _this = (KAGParserNI)objthis.getNativeInstance(mClassID);
				if( _this == null ) return E_NATIVECLASSCRASH;
				Dispatch2 dsp = _this.store();
				if(result!=null) result.set(dsp, dsp);
				return S_OK;
			}
		}, CLASS_NAME, nitMethod, 0 );

		registerNCM( "restore", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws TJSException {
				KAGParserNI _this = (KAGParserNI)objthis.getNativeInstance(mClassID);
				if( _this == null ) return E_NATIVECLASSCRASH;
				if( param.length < 1 ) return E_BADPARAMCOUNT;
				Dispatch2 dsp = param[0].asObject();
				_this.restore(dsp);
				return S_OK;
			}
		}, CLASS_NAME, nitMethod, 0 );

		registerNCM( "clearCallStack", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws VariantException {
				KAGParserNI _this = (KAGParserNI)objthis.getNativeInstance(mClassID);
				if( _this == null ) return E_NATIVECLASSCRASH;
				_this.clearCallStack();
				return S_OK;
			}
		}, CLASS_NAME, nitMethod, 0 );

		registerNCM( "popMacroArgs", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws TJSException {
				KAGParserNI _this = (KAGParserNI)objthis.getNativeInstance(mClassID);
				if( _this == null ) return E_NATIVECLASSCRASH;
				_this.popMacroArgs();
				return S_OK;
			}
		}, CLASS_NAME, nitMethod, 0 );

		registerNCM( "interrupt", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws VariantException {
				KAGParserNI _this = (KAGParserNI)objthis.getNativeInstance(mClassID);
				if( _this == null ) return E_NATIVECLASSCRASH;
				_this.interrupt();
				return S_OK;
			}
		}, CLASS_NAME, nitMethod, 0 );

		registerNCM( "resetInterrupt", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws VariantException {
				KAGParserNI _this = (KAGParserNI)objthis.getNativeInstance(mClassID);
				if( _this == null ) return E_NATIVECLASSCRASH;
				_this.resetInterrupt();
				return S_OK;
			}
		}, CLASS_NAME, nitMethod, 0 );


		registerNCM( "curLine", new NativeClassProperty() {
			@Override public int get(Variant result, Dispatch2 objthis) {
				KAGParserNI _this = (KAGParserNI)objthis.getNativeInstance(mClassID);
				if( _this == null ) return E_NATIVECLASSCRASH;
				result.set( _this.getCurLine() );
				return S_OK;
			}
			@Override public int set(Variant param, Dispatch2 objthis) { return E_ACCESSDENYED; }
		}, CLASS_NAME, nitProperty, 0 );

		registerNCM( "curPos", new NativeClassProperty() {
			@Override public int get(Variant result, Dispatch2 objthis) {
				KAGParserNI _this = (KAGParserNI)objthis.getNativeInstance(mClassID);
				if( _this == null ) return E_NATIVECLASSCRASH;
				result.set( _this.getCurPos() );
				return S_OK;
			}
			@Override public int set(Variant param, Dispatch2 objthis) { return E_ACCESSDENYED; }
		}, CLASS_NAME, nitProperty, 0 );

		registerNCM( "curLineStr", new NativeClassProperty() {
			@Override public int get(Variant result, Dispatch2 objthis) {
				KAGParserNI _this = (KAGParserNI)objthis.getNativeInstance(mClassID);
				if( _this == null ) return E_NATIVECLASSCRASH;
				result.set( _this.getCurLineStr() );
				return S_OK;
			}
			@Override public int set(Variant param, Dispatch2 objthis) { return E_ACCESSDENYED; }
		}, CLASS_NAME, nitProperty, 0 );

		registerNCM( "processSpecialTags", new NativeClassProperty() {
			@Override public int get(Variant result, Dispatch2 objthis) {
				KAGParserNI _this = (KAGParserNI)objthis.getNativeInstance(mClassID);
				if( _this == null ) return E_NATIVECLASSCRASH;
				result.set( _this.getProcessSpecialTags() ? 1 : 0 );
				return S_OK;
			}
			@Override public int set(Variant param, Dispatch2 objthis) {
				KAGParserNI _this = (KAGParserNI)objthis.getNativeInstance(mClassID);
				if( _this == null ) return E_NATIVECLASSCRASH;
				_this.setProcessSpecialTags(param.asBoolean());
				return S_OK;
			}
		}, CLASS_NAME, nitProperty, 0 );

		registerNCM( "ignoreCR", new NativeClassProperty() {
			@Override public int get(Variant result, Dispatch2 objthis) {
				KAGParserNI _this = (KAGParserNI)objthis.getNativeInstance(mClassID);
				if( _this == null ) return E_NATIVECLASSCRASH;
				result.set( _this.getIgnoreCR() ? 1 : 0 );
				return S_OK;
			}
			@Override public int set(Variant param, Dispatch2 objthis) {
				KAGParserNI _this = (KAGParserNI)objthis.getNativeInstance(mClassID);
				if( _this == null ) return E_NATIVECLASSCRASH;
				_this.setIgnoreCR(param.asBoolean());
				return S_OK;
			}
		}, CLASS_NAME, nitProperty, 0 );

		registerNCM( "debugLevel", new NativeClassProperty() {
			@Override public int get(Variant result, Dispatch2 objthis) {
				KAGParserNI _this = (KAGParserNI)objthis.getNativeInstance(mClassID);
				if( _this == null ) return E_NATIVECLASSCRASH;
				result.set( _this.getDebugLevel() );
				return S_OK;
			}
			@Override public int set(Variant param, Dispatch2 objthis) throws VariantException {
				KAGParserNI _this = (KAGParserNI)objthis.getNativeInstance(mClassID);
				if( _this == null ) return E_NATIVECLASSCRASH;
				_this.setDebugLevel(param.asInteger());
				return S_OK;
			}
		}, CLASS_NAME, nitProperty, 0 );

		registerNCM( "macros", new NativeClassProperty() {
			@Override public int get(Variant result, Dispatch2 objthis) {
				KAGParserNI _this = (KAGParserNI)objthis.getNativeInstance(mClassID);
				if( _this == null ) return E_NATIVECLASSCRASH;
				Dispatch2 macros = _this.getMacros();
				result.set(macros, macros);
				return S_OK;
			}
			@Override public int set(Variant param, Dispatch2 objthis) { return E_ACCESSDENYED; }
		}, CLASS_NAME, nitProperty, 0 );

		registerNCM( "macroParams", new NativeClassProperty() {
			@Override public int get(Variant result, Dispatch2 objthis) {
				KAGParserNI _this = (KAGParserNI)objthis.getNativeInstance(mClassID);
				if( _this == null ) return E_NATIVECLASSCRASH;
				Dispatch2 macros = _this.getMacroTop();
				result.set(macros, macros);
				return S_OK;
			}
			@Override public int set(Variant param, Dispatch2 objthis) { return E_ACCESSDENYED; }
		}, CLASS_NAME, nitProperty, 0 );

		registerNCM( "mp", new NativeClassProperty() {
			@Override public int get(Variant result, Dispatch2 objthis) {
				KAGParserNI _this = (KAGParserNI)objthis.getNativeInstance(mClassID);
				if( _this == null ) return E_NATIVECLASSCRASH;
				Dispatch2 macros = _this.getMacroTop();
				result.set(macros, macros);
				return S_OK;
			}
			@Override public int set(Variant param, Dispatch2 objthis) { return E_ACCESSDENYED; }
		}, CLASS_NAME, nitProperty, 0 );

		registerNCM( "callStackDepth", new NativeClassProperty() {
			@Override public int get(Variant result, Dispatch2 objthis) {
				KAGParserNI _this = (KAGParserNI)objthis.getNativeInstance(mClassID);
				if( _this == null ) return E_NATIVECLASSCRASH;
				result.set( _this.getCallStackDepth() );
				return S_OK;
			}
			@Override public int set(Variant param, Dispatch2 objthis) { return E_ACCESSDENYED; }
		}, CLASS_NAME, nitProperty, 0 );

		registerNCM( "curStorage", new NativeClassProperty() {
			@Override public int get(Variant result, Dispatch2 objthis) {
				KAGParserNI _this = (KAGParserNI)objthis.getNativeInstance(mClassID);
				if( _this == null ) return E_NATIVECLASSCRASH;
				result.set( _this.getStorageName() );
				return S_OK;
			}
			@Override public int set(Variant param, Dispatch2 objthis) throws TJSException {
				KAGParserNI _this = (KAGParserNI)objthis.getNativeInstance(mClassID);
				if( _this == null ) return E_NATIVECLASSCRASH;
				_this.loadScenario(param.asString());
				return S_OK;
			}
		}, CLASS_NAME, nitProperty, 0 );

		registerNCM( "curLabel", new NativeClassProperty() {
			@Override public int get(Variant result, Dispatch2 objthis) {
				KAGParserNI _this = (KAGParserNI)objthis.getNativeInstance(mClassID);
				if( _this == null ) return E_NATIVECLASSCRASH;
				result.set( _this.getCurLabel() );
				return S_OK;
			}
			@Override public int set(Variant param, Dispatch2 objthis) { return E_ACCESSDENYED; }
		}, CLASS_NAME, nitProperty, 0 );
	}

}
