package jp.kirikiri.tjs2;

import java.util.Random;

public class MathClass extends NativeClass {

	static private final int
		E_BADPARAMCOUNT	= -1004,
		S_OK			= 0;
	static private final int E_ACCESSDENYED = -1007;

	static public int mClassID;
	static private Random mRandomGenerator;

	static final private int
		nitMethod	= 1,
		nitProperty = 2;

	static final private int STATICMEMBER	= 0x00010000;

	static final private String CLASS_NAME = "Math";

	public MathClass() throws VariantException, TJSException {
		super(CLASS_NAME);

		if( mRandomGenerator == null ) {
			mRandomGenerator = new Random( System.currentTimeMillis() );
		}

		final int NCM_CLASSID = TJS.registerNativeClass(CLASS_NAME);
		setClassID( NCM_CLASSID );
		mClassID = NCM_CLASSID;

		// constructor
		registerNCM( CLASS_NAME, new NativeClassConstructor() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) {
				return S_OK;
			}
			}, CLASS_NAME, nitMethod, 0 );

		registerNCM( "abs", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws VariantException {
				if( param.length < 1 ) return E_BADPARAMCOUNT;
				if( result != null ) result.set( Math.abs( param[0].asDouble() ) );
				return S_OK;
			}
			}, CLASS_NAME, nitMethod, STATICMEMBER );

		registerNCM( "acos", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws VariantException {
				if( param.length < 1 ) return E_BADPARAMCOUNT;
				if( result != null ) result.set( Math.acos( param[0].asDouble() ) );
				return S_OK;
			}
			}, CLASS_NAME, nitMethod, STATICMEMBER );

		registerNCM( "asin", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws VariantException {
				if( param.length < 1 ) return E_BADPARAMCOUNT;
				if( result != null ) result.set( Math.asin( param[0].asDouble() ) );
				return S_OK;
			}
			}, CLASS_NAME, nitMethod, STATICMEMBER );

		registerNCM( "atan", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws VariantException {
				if( param.length < 1 ) return E_BADPARAMCOUNT;
				if( result != null ) result.set( Math.atan( param[0].asDouble() ) );
				return S_OK;
			}
			}, CLASS_NAME, nitMethod, STATICMEMBER );

		registerNCM( "atan2", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws VariantException {
				if( param.length < 2 ) return E_BADPARAMCOUNT;
				if( result != null ) result.set( Math.atan2( param[0].asDouble(), param[1].asDouble() ) );
				return S_OK;
			}
			}, CLASS_NAME, nitMethod, STATICMEMBER );

		registerNCM( "ceil", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws VariantException {
				if( param.length < 1 ) return E_BADPARAMCOUNT;
				if( result != null ) result.set( Math.ceil( param[0].asDouble() ) );
				return S_OK;
			}
			}, CLASS_NAME, nitMethod, STATICMEMBER );

		registerNCM( "exp", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws VariantException {
			if( param.length < 1 ) return E_BADPARAMCOUNT;
			if( result != null ) result.set( Math.exp( param[0].asDouble() ) );
			return S_OK;
		}
		}, CLASS_NAME, nitMethod, STATICMEMBER );

		registerNCM( "floor", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws VariantException {
				if( param.length < 1 ) return E_BADPARAMCOUNT;
				if( result != null ) result.set( Math.floor( param[0].asDouble() ) );
				return S_OK;
			}
		}, CLASS_NAME, nitMethod, STATICMEMBER );

		registerNCM( "log", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws VariantException {
				if( param.length < 1 ) return E_BADPARAMCOUNT;
				if( result != null ) result.set( Math.log( param[0].asDouble() ) );
				return S_OK;
			}
		}, CLASS_NAME, nitMethod, STATICMEMBER );

		registerNCM( "pow", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws VariantException {
				if( param.length < 2 ) return E_BADPARAMCOUNT;
				if( result != null ) result.set( Math.pow( param[0].asDouble(), param[1].asDouble() ) );
				return S_OK;
			}
		}, CLASS_NAME, nitMethod, STATICMEMBER );

		registerNCM( "max", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws VariantException {
				if( result != null ) {
					double r = Double.NEGATIVE_INFINITY;
					final int count = param.length;
					for( int i = 0; i < count; i++ ) {
						double v = param[i].asDouble();
						if( Double.isNaN(v) ) {
							result.set( Double.NaN );
							return S_OK;
						} else if( Double.compare( v, r ) > 0 ) {
							r = v;
						}
					}
					result.set( r );
				}
				return S_OK;
			}
		}, CLASS_NAME, nitMethod, STATICMEMBER );

		registerNCM( "min", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws VariantException {
				if( result != null ) {
					double r = Double.POSITIVE_INFINITY;
					final int count = param.length;
					for( int i = 0; i < count; i++ ) {
						double v = param[i].asDouble();
						if( Double.isNaN(v) ) {
							result.set( Double.NaN );
							return S_OK;
						} else if( Double.compare( v, r ) < 0 ) {
							r = v;
						}
					}
					result.set( r );
				}
				return S_OK;
			}
		}, CLASS_NAME, nitMethod, STATICMEMBER );

		registerNCM( "random", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws VariantException {
				if( result != null ) result.set( mRandomGenerator.nextDouble() );
				return S_OK;
			}
		}, CLASS_NAME, nitMethod, STATICMEMBER );

		registerNCM( "round", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws VariantException {
				if( param.length < 1 ) return E_BADPARAMCOUNT;
				if( result != null ) result.set( Math.round( param[0].asDouble() ) );
				return S_OK;
			}
		}, CLASS_NAME, nitMethod, STATICMEMBER );

		registerNCM( "sin", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws VariantException {
				if( param.length < 1 ) return E_BADPARAMCOUNT;
				if( result != null ) result.set( Math.sin( param[0].asDouble() ) );
				return S_OK;
			}
		}, CLASS_NAME, nitMethod, STATICMEMBER );

		registerNCM( "cos", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws VariantException {
				if( param.length < 1 ) return E_BADPARAMCOUNT;
				if( result != null ) result.set( Math.cos( param[0].asDouble() ) );
				return S_OK;
			}
		}, CLASS_NAME, nitMethod, STATICMEMBER );

		registerNCM( "sqrt", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws VariantException {
				if( param.length < 1 ) return E_BADPARAMCOUNT;
				if( result != null ) result.set( Math.sqrt( param[0].asDouble() ) );
				return S_OK;
			}
		}, CLASS_NAME, nitMethod, STATICMEMBER );

		registerNCM( "tan", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws VariantException {
				if( param.length < 1 ) return E_BADPARAMCOUNT;
				if( result != null ) result.set( Math.tan( param[0].asDouble() ) );
				return S_OK;
			}
		}, CLASS_NAME, nitMethod, STATICMEMBER );

		registerNCM( "E", new NativeClassProperty() {
			@Override
			public int get(Variant result, Dispatch2 objthis) {
				result.set( 2.7182818284590452354 );
				return S_OK;
			}
			@Override public int set(Variant param, Dispatch2 objthis) { return E_ACCESSDENYED; }
		}, CLASS_NAME, nitProperty, STATICMEMBER );

		registerNCM( "LOG2E", new NativeClassProperty() {
			@Override
			public int get(Variant result, Dispatch2 objthis) {
				result.set( 1.4426950408889634074 );
				return S_OK;
			}
			@Override public int set(Variant param, Dispatch2 objthis) { return E_ACCESSDENYED; }
		}, CLASS_NAME, nitProperty, STATICMEMBER );

		registerNCM( "LOG10E", new NativeClassProperty() {
			@Override
			public int get(Variant result, Dispatch2 objthis) {
				result.set( 0.4342944819032518276 );
				return S_OK;
			}
			@Override public int set(Variant param, Dispatch2 objthis) { return E_ACCESSDENYED; }
		}, CLASS_NAME, nitProperty, STATICMEMBER );

		registerNCM( "LN10", new NativeClassProperty() {
			@Override
			public int get(Variant result, Dispatch2 objthis) {
				result.set( 2.30258509299404568402 );
				return S_OK;
			}
			@Override public int set(Variant param, Dispatch2 objthis) { return E_ACCESSDENYED; }
		}, CLASS_NAME, nitProperty, STATICMEMBER );

		registerNCM( "LN2", new NativeClassProperty() {
			@Override
			public int get(Variant result, Dispatch2 objthis) {
				result.set( 0.69314718055994530942 );
				return S_OK;
			}
			@Override public int set(Variant param, Dispatch2 objthis) { return E_ACCESSDENYED; }
		}, CLASS_NAME, nitProperty, STATICMEMBER );

		registerNCM( "PI", new NativeClassProperty() {
			@Override
			public int get(Variant result, Dispatch2 objthis) {
				result.set( 3.14159265358979323846 );
				return S_OK;
			}
			@Override public int set(Variant param, Dispatch2 objthis) { return E_ACCESSDENYED; }
		}, CLASS_NAME, nitProperty, STATICMEMBER );

		registerNCM( "SQRT1_2", new NativeClassProperty() {
			@Override
			public int get(Variant result, Dispatch2 objthis) {
				result.set( 0.70710678118654752440 );
				return S_OK;
			}
			@Override public int set(Variant param, Dispatch2 objthis) { return E_ACCESSDENYED; }
		}, CLASS_NAME, nitProperty, STATICMEMBER );

		registerNCM( "SQRT2", new NativeClassProperty() {
			@Override
			public int get(Variant result, Dispatch2 objthis) {
				result.set( 1.41421356237309504880 );
				return S_OK;
			}
			@Override public int set(Variant param, Dispatch2 objthis) { return E_ACCESSDENYED; }
		}, CLASS_NAME, nitProperty, STATICMEMBER );
	}
}
